#!/usr/bin/perl -w
# 
# sb::Plugin::RealTimeOnlineCounter Connector - Plugin Module for Serene Bach
# - Written by Gin-Lime / published on 2006-03-29
# -- `Serene Bach' is written by T.Otani
# --   Copyright (C) 2005- SimpleBoxes/SerendipityNZ.

package sb::Plugin::RTOCC;
# ==================================================
# // initialization for plugin
# ==================================================
use sb::Plugin ();
sb::Plugin->register_plugin(
	'lang' => {
		'ja' => 'euc',
		'en' => 'ascii',
	},
	'text' => {
		'type'    => 'cms',
		'name'    => 'RealTimeOnlineCounter Connector',
		'text'    => 'Provides a script statement for connection to RealTimeOnlineCounter.',
		'author'  => 'Gin-Lime',
		'detail'  => 'http://www.emeraldshell.com/sb/',
		'version' => '0.02',
		'publish' => 'yes',	# ץ饰ꥹȤΤγĥʸ/
	},
	'file' => 'rtocforsb.txt',
	'data' => undef,
);
# cmsѥץ饰ȤϿ
sb::Plugin->register_content_module(
	'type'     => 'main',
	'callback' => \&sb::Content::RTOCC::_rtoc_connect,
	'field'    => 'rtoc_connect',
);
package sb::Content::RTOCC;
# ==================================================
# // declaration for constant value
# ==================================================
sub SCRIPT (){ 
	$script = <<'_END_OF_SCRIPT_';
<div id="rtoc">&nbsp;</div>
<!-- POWERED BY RTOC REAL-TIME ONLINE COUNTER HTTP://WWW.J-FX.WS/RTOC/ -->
<script type="text/javascript" language="javascript">
<!--
if (window.XMLHttpRequest) { 
    xmlHttp = new XMLHttpRequest();
} else if (window.ActiveXObject) { 
    xmlHttp = new ActiveXObject("Microsoft.XMLHTTP");
}
function callServer(url) {
  xmlHttp.open("GET", url, true);
  xmlHttp.onreadystatechange = updatePage;
  xmlHttp.send(null);
}
function updatePage() {
  if (xmlHttp.readyState == 4) {
    var response = xmlHttp.responseText;
    document.getElementById("rtoc").innerHTML = response;
    setTimeout("callServer('%srtoc.php')",2500);
  }
}
callServer("%srtoc.php");
// -->
</script>
_END_OF_SCRIPT_
	return $script;
};
# ==================================================
# // functions for content
# ==================================================
use sb::Config ();
use sb::Content ();
use sb::Text ();
sub _rtoc_connect {
	my $cms = shift;
	my %var = @_;
	my $phpscript = $var{'conf'}->value('conf_srv_cgi') . sb::Plugin::get_resource_dir;
	$phpscript =~ s/\/\.\//\//;
	$cms->tag('sb_rtocc'=>sprintf(SCRIPT,$phpscript,$phpscript));
	return(1);
}

1;
# require 뤿Τޤʤ
__END__

