#!/usr/bin/perl -w
# 
# sb::Plugin::RecentAccessLog - Plugin Module for Serene Bach
# - Written by Gin-Lime / published on 2006-05-29
# -- `Serene Bach' is written by T.Otani
# --   Copyright (C) 2005- SimpleBoxes/SerendipityNZ.

package sb::Plugin::RecentAccessLog;
# ==================================================
# // initialization for plugin
# ==================================================
use sb::Plugin ();
sb::Plugin->register_plugin(
	'lang' => {
		'ja' => 'euc',
		'en' => 'ascii',
	},
	'text' => {
		'type'    => 'admin',
		'name'    => 'Recent Access Log',
		'text'    => 'Shows access logs specified for recent refferer',
		'author'  => 'Gin-Lime',
		'detail'  => 'http://www.emeraldshell.com/sb/',
		'version' => '0.10',
		'publish' => 'yes',	# ץ饰ꥹȤΤγĥʸ/
	},
	'file' => 'recentaccesslog.txt',
	'data' => 1,
);
# adminѥץ饰ȤϿ
sb::Plugin->register_admin_module(
	'mode'   => 'recentaccesslog',
	'level'  => 1,
	'module' => 'sb::Admin::RecentAccessLog',
);

package sb::Admin::RecentAccessLog;
use vars qw( @ISA );
@ISA = qw( sb::Admin::AccessLog );
use sb::Interface ();
use sb::TemplateManager ();
use sb::Language ();
use sb::Time ();
use sb::Data ();
use sb::Config ();
use sb::Lock ();
# ==================================================
# // declaration for constant value
# ==================================================
sub TEMPLATE               (){ 'recentaccesslog.html' };
sub DEFAULT_ITEMS          (){ '100' };
sub COUNTERMEASURE_ANTENNA (){ '0' };
sub DEFAULT_SCREEN         (){ 'log' };
sub PARTS_BAR              (){ 'accesslog_bar.gif' };
sub BAR_MAX_W              (){ 300 };
# ==================================================
# // declaration for class member
# ==================================================
# 󥸥 from YetAnotherAccessLog.pm
my %mEngines = (
	'www\.google\.(co\.[a-z][a-z]|com[.]?[a-z]*|[a-z]+)/(search|custom)' => {
		'name' => '<a href="http://www.google.com/">Google</a>',
	},
	'http://[\d]+\.[\d]+.[\d]+\.[\d]+/search$' => {
		'name' => '<a href="http://www.google.com/">Google</a>',
	},
	'search\.yahoo\.co\.jp/' => {
		'name' => '<a href="http://www.yahoo.co.jp/">Yahoo!</a>',
	},
	'search\.goo\.ne\.jp/' => {
		'name' => '<a href="http://www.goo.ne.jp/">Goo</a>',
	},
	'excite\.co\.jp/search\.gw' => {
		'name' => '<a href="http://www.excite.co.jp/">Excite</a>',
	},
	'search\.msn\.co\.jp/' => {
		'name' => '<a href="http://www.msn.co.jp/">MSN</a>',
	},
	'search\.nifty\.com/cgi-bin/search\.cgi' => {
		'name' => '<a href="http://www.nifty.com/">@nifty</a>',
	},
	'search\.biglobe\.ne\.jp/cgi-bin/search' => {
		'name' => '<a href="http://www.biglobe.ne.jp/">BIGLOBE</a>',
	},
	'www\.infoseek\.co\.jp/[O]?Titles' => {
		'name' => '<a href="http://www.infoseek.co.jp/">infoseek</a>',
	},
	'(sf|search)\.livedoor\.com/search' => {
		'name' => '<a href="http://www.livedoor.com/">livedoor</a>',
	},
	'bulkfeeds\.net/app/search' => {
		'name' => '<a href="http://bulkfeeds.net/">bulkfeeds</a>',
	},
	'www\.myblog\.jp/search_text/' => {
		'name' => '<a href="http://myblog.jp/">myblog.jp</a>',
	},
	'news\.drecom\.jp/search/index\.php' => {
		'name' => '<a href="http://news.drecom.jp/">News&amp;BlogSearch(drecom)</a>',
	},
	'search\.jp\.aol\.com' => {
		'name' => '<a href="http://www.aol.com/">AOL Search</a>',
	},
	'http://ask\.jp/web\.asp' => {
		'name' => '<a href="http://ask.jp/">ask.jp</a>',
	},
	'http://blog.with2.net/find_item.php' => {
		'name' => '<a href="http://blog.with2.net">Blog Ranking</a>',
	},
	'search\.jword\.jp' => {
		'name' => '<a href="http://jword.jp/">JWord</a>',
	},
);
# ==================================================
# // public functions - callback
# ==================================================
sub callback {
	my $self = shift;
	return ( $self->{'regi'} ) 
		? $self->_save_setting(@_)
		: $self->_show_accesslog(@_);
}
# ==================================================
# // private functions - main routine
# ==================================================
sub _save_setting {
	my $self = shift;
	my $cgi  = sb::Interface->get;
	if($cgi->value('term_day') ne '') {
		return $self->_show_accesslog('screen'=>'log','message'=>sb::Language->get->string('parts_ralog_termspecified'),'term_date'=>$cgi->value('term_day'),'start'=>$cgi->value('term_start'),'end'=>$cgi->value('term_end'));
	} else {
		# ǡμ
		my $set_data = sb::Plugin->get_data;
		# μ
		$set_data->extra($cgi->value('items_number'));
		$set_data->setting($cgi->value('cm_antenna'));
		# ǡ¸
		sb::Plugin->set_data('data' => $set_data);
		return $self->_show_accesslog('screen'=>'log','message'=>sb::Language->get->string('parts_confcomp'));
	}
}
sub _show_accesslog {
	my $self = shift;
	my %param = ('screen' => '','message' => '','term_date' => '','start' => '','end' => '', @_);
	my $cms  = sb::TemplateManager->new(sb::Plugin->load_template('file' => TEMPLATE));
	my $set_data = sb::Plugin->get_data;
	my $items_number = ($set_data->extra) ? $set_data->extra : DEFAULT_ITEMS;
	my $cm_antenna = ($set_data->setting) ? $set_data->setting : COUNTERMEASURE_ANTENNA;
	my $screen = ($param{'screen'} ne '') ? $param{'screen'} : DEFAULT_SCREEN;
	my $cgi = sb::Interface->get;
	my $conf = sb::Config->get;
	my $zone = &sb::Time::_zone($conf->value('conf_timezone'));
	my $now = $self->{'time'};
	$screen = $cgi->value('__type') if($cgi->value('__type') ne '');
	if($screen eq 'setting') {	# ξ
		# ȼͤ
		$cms->num(0);
		$cms->tag('sb_ralog_items_50' =>
			($items_number eq '50') ? ' selected' : '' );
		$cms->tag('sb_ralog_items_100' =>
			($items_number eq '100') ? ' selected' : '' );
		$cms->tag('sb_ralog_items_200' =>
			($items_number eq '200') ? ' selected' : '' );
		$cms->tag('sb_ralog_items_300' =>
			($items_number eq '300') ? ' selected' : '' );
		$cms->tag('sb_ralog_items_400' =>
			($items_number eq '400') ? ' selected' : '' );
		$cms->tag('sb_ralog_items_500' =>
			($items_number eq '500') ? ' selected' : '' );
		$cms->tag('sb_ralog_cm_0' =>
			($cm_antenna eq '0') ? ' selected' : '' );
		$cms->tag('sb_ralog_cm_1' =>
			($cm_antenna eq '1') ? ' selected' : '' );
	} elsif($screen eq 'referrer') {	# 󥯸ɽξ
		my ($sttoday, $stweek) = &_starttime($now,$zone);
		my $lock  = sb::Lock->lock or die($lang->string('error_file_lock')) if (!$self->{'lock'});
		my @files = $self->_load_logfile('expire' => $conf->value('conf_checklog'));
		$lock->unlock if ($lock);

		my $barimg = sb::Plugin->get_resource_dir . PARTS_BAR;
		@files = sort { $b cmp $a } @files;
		my %state = $self->_analyze_log($sttoday,$stweek,$cm_antenna,@files);
		if ($self->{'count_refweek'} > 0) {
			foreach my $check ('reftoday','refweek') {
				my @order  = sort { $state{$check}{$b} <=> $state{$check}{$a} } keys( %{$state{$check}} );
				my $pretag = 'sb_' . $check . '_';
				my $num = 0;
				foreach my $elem ( @order ) {
					my $disp = '';
					$disp = &_display_refs($self, $elem);
					next if ($disp eq '');
					$cms->num($num);
					$cms->tag($pretag . 'refs' => $disp);
					$cms->tag($pretag . 'bar' => int( $state{$check}{$elem} * BAR_MAX_W / $self->{'count_' . $check} ));
					$cms->tag($pretag . 'num' => $state{$check}{$elem});
					$cms->tag('sb_access_bar'=>$barimg);
					$cms->tag('sb_list_class'=>($num % 2) ? 'odd' : 'even');
					$num++;
				}
				$cms->block($pretag . 'list' => $num);
			}
			# ȼͤ
			$cms->block(sb_ralog_referrer_reflist => 1);
			$cms->num(0);
			$cms->tag('refweek_date' => &_format_date($stweek,$zone) . sb::Language->get->string('parts_ralog_between') . &_format_date($now,$zone));
		} else {
			$cms->num(0);
			$cms->block('sb_ralog_referrer_message' => 1);
			$cms->tag('sb_ralog_referrer_message' => sb::Language->get->string('parts_ralog_norefs'));
		}
	} else {	# ɽξ
		my @logs = ();
		my $conf = sb::Config->get;
		my $lock  = sb::Lock->lock or die($lang->string('error_file_lock')) if (!$self->{'lock'});
		my @files = $self->_load_logfile('expire' => $conf->value('conf_checklog'));
		$lock->unlock if ($lock);
		@files = sort { $b cmp $a } @files;
		my $term_date = '';
		my $term_start = 0;
		my $term_end = 0;
		if($param{'term_date'} ne '') { # ɽξ
			$term_date = $param{'term_date'};
			my $term_start_tmp = int($param{'start'});
			my $term_end_tmp = int($param{'end'});
			if($term_end_tmp < $term_start_tmp) {
				$term_start = $term_end_tmp;
				$term_end = $term_start_tmp;
			} else {
				$term_start = $term_start_tmp;
				$term_end = $term_end_tmp;
			}
		}
		my $date_format = $conf->value('conf_entry_date');
		my $time_lang = $conf->value('conf_time_lang');
		my $term_day_tag = '';
		my @files_cl = @files;
		pop(@files_cl);
		foreach my $file (@files_cl) {
			my $tmpdate = int(substr($file,0,8));
			my $tmpyear = int(substr($tmpdate,0,4));
			my $tmpmonth = int(substr($tmpdate,4,2));
			my $tmpday = int(substr($tmpdate,6,2));
			my $tmpformatted = sb::Time->format(
				'time' => &_get_timegm($tmpyear,$tmpmonth - 1,$tmpday,0),
				'form' => $date_format,
				'zone' => $zone,
				'lang' => $time_lang,
				);
			$term_day_tag .= '<option value="' . $tmpdate . '"';
			$term_day_tag .= ' selected' if($tmpdate eq $term_date);
			$term_day_tag .= '>' . $tmpformatted . '</option>' . "\n";
		}
		my $term_start_tag = '';
		my $term_end_tag = '';
		for(my $i = 0;$i < 24; $i++) {
			$term_start_tag .= '<option value="' . $i . '"';
			$term_start_tag .= ' selected' if($i eq $term_start);
			$term_start_tag .= '>' . $i . '</option>' . "\n";
			$term_end_tag .= '<option value="' . $i . '"';
			$term_end_tag .= ' selected' if($i eq $term_end);
			$term_end_tag .= '>' . $i . '</option>' . "\n";
		}
		$cms->num(0);
		$cms->tag('sb_ralog_term' => $term_day_tag);
		$cms->tag('sb_ralog_term_start' => $term_start_tag);
		$cms->tag('sb_ralog_term_end' => $term_end_tag);
		$cms->tag('sb_total_access'=>$self->_load_counter);
		my $today_access = $self->_load_access($now,$zone,'today');
		my $yesterday_access = $self->_load_access($now,$zone,'yesterday');
		if($yesterday_access != 0) {
			$today_access .= sprintf(sb::Language->get->string('parts_ralog_count_yesterday'),$yesterday_access);
		}
		$cms->tag('sb_today_access'=>$today_access);
		if($param{'term_date'} ne '') { # ɽξ
			my $term_year = int(substr($term_date,0,4));
			my $term_month = int(substr($term_date,4,2));
			my $term_day = int(substr($term_date,6,2));
			$term_start = &_get_timegm($term_year, $term_month - 1, $term_day, $term_start) - $zone;
			$term_end++;
			if($term_end == 24) {
				$term_end = 0;
				my $end_date = &_get_timegm($term_year, $term_month - 1, $term_day, 0) - $zone;
				($term_day, $term_month, $term_year) = &_get_tomorrow($end_date,$zone);
			}
			$term_end = &_get_timegm($term_year, $term_month - 1, $term_day, $term_end) - $zone;
			@logs = $self->_abstract_termlog($items_number,$term_date,$term_start,$term_end,$zone,$cm_antenna);
			# ȼͤ
			if ($self->{'log_items'} > 0) {
				$cms->num(0);
				$cms->block('sb_ralog_log_loglist' => 1);
				my $num = 0;
				foreach my $log ( @logs ) {
					my @elem = ($log =~ /(.*?)<>/g);
					$cms->num($num);
					$cms->tag('sb_accesslog_date' => $elem[0]);
					$cms->tag('sb_accesslog_host' => $elem[1]);
					$cms->tag('sb_accesslog_agent' => $elem[2]);
					$cms->tag('sb_accesslog_referrer' => $elem[3]);
					$cms->tag('sb_list_class'=>($num % 2) ? 'odd' : 'even');
					$num++;
				}
				$cms->block('sb_accesslog_list' => $num);
				$cms->num(0);
				my $showing = $self->{'log_items'} . sb::Language->get->string('parts_ralog_itemordinal') . ' (' . &_format_date($term_start,$zone) . ' ' . &_format_time($term_start,$zone);
				if($param{'start'} ne $param{'end'}) {
					$showing .= sb::Language->get->string('parts_ralog_between') . &_format_time($term_end,$zone,'end');
				}
				$showing .= ')';
				$cms->tag('sb_ralog_showing' => $showing);
				if ($self->{'log_surplus'} > 0) {
					$cms->num(0);
					$cms->block('sb_ralog_log_message' => 1);
					$cms->tag('sb_ralog_log_message' => sprintf(sb::Language->get->string('parts_ralog_surplus'), $self->{'log_surplus'}));
				}
			} else {
				$cms->num(0);
				$cms->block('sb_ralog_log_message' => 1);
				if($self->{'log_deleted'} eq '1') {
					$cms->tag('sb_ralog_log_message' => sb::Language->get->string('parts_ralog_deleted'));
				} else {
					$cms->tag('sb_ralog_log_message' => sb::Language->get->string('parts_ralog_nospecifiedlog'));
				}
			}
		} else {
			@logs = $self->_abstract_log($items_number,$zone,$cm_antenna,@files);
			if ($self->{'log_items'} > 0) {
				$cms->num(0);
				$cms->block('sb_ralog_log_loglist' => 1);
				my $num = 0;
				foreach my $log ( @logs ) {
					my @elem = ($log =~ /(.*?)<>/g);
					$cms->num($num);
					$cms->tag('sb_accesslog_date' => $elem[0]);
					$cms->tag('sb_accesslog_host' => $elem[1]);
					$cms->tag('sb_accesslog_agent' => $elem[2]);
					$cms->tag('sb_accesslog_referrer' => $elem[3]);
					$cms->tag('sb_list_class'=>($num % 2) ? 'odd' : 'even');
					$num++;
				}
				# ȼͤ
				$cms->block('sb_accesslog_list' => $num);
				$cms->num(0);
				$cms->tag('sb_ralog_showing' => $self->{'log_items'} . sb::Language->get->string('parts_ralog_itemordinal'));
			} else {
				$cms->num(0);
				$cms->block('sb_ralog_log_message' => 1);
				$cms->tag('sb_ralog_log_message' => sb::Language->get->string('parts_ralog_noaccesslog'));
			}
		}
	}
	$cms->num(0);
	# åɽ
	if ($param{'message'} ne '') {
		$cms->tag('sb_process_message' => $param{'message'});
		$cms->block('sb_process_message' => 1);
	}
	my $blog = sb::Data->load('Weblog','id'=>0);
	$cms->tag('sb_blog_name'=>$blog->title);
	$cms->tag('sb_ralog_menu_' . $screen => 'class="current"');
	$cms->block('sb_ralog_' . $screen => 1);

	# ̤ɽ
	return sb::Interface->get->head('type'=>'text/html') . $self->set_main($cms->output);
}
# ==================================================
# // private functions
# ==================================================
sub _convert_agent {	# from AccessLog.pm
	my $agent = shift;
	my ($os,$br) = ();
	$os = 'Win' if ($agent =~ /Win/i or $agent =~ /Sleipnir/i);	# Sleipnir ɵ by GLM
	if ($os ne '') {
		$os = 'WinXP' if ($agent =~ /NT 5\.1/i or $agent =~ /XP/i);
		$os = 'Win2K' if ($agent =~ /NT 5\.0/i or $agent =~ /2000/i);
		$os = 'WinNT' if ($agent =~ /NT/i and ($os ne 'WinXP' and $os ne 'Win2K'));
		$os = 'Win9x' if ($agent =~ /95/ or $agent =~ /98/ or $agent =~ /9x/i or $agent =~ /Me/i);
	}
	$os = 'Mac'      if ($agent =~ /Mac/i);
	$os = 'Mac OS X' if ($agent =~ /Mac OS X/i);
	$os = 'Mac OS X' if ($os eq 'Mac' and $agent =~ /MSIE 5\.2/);
	$os = 'Linux'    if ($agent =~ /Linux/);
	$os = 'Mobile'   if ($agent =~ /WILLCOM/);	# by GLM
	$os = 'Win?'     if ($os eq '' and $agent eq '*Internet Explorer');	# by GLM
	$os = 'PDA'      if ($agent =~ /PDA/);	# by GLM
	$br = 'IE5'            if ($agent =~ /MSIE 5/i);
	$br = 'IE5.5'          if ($agent =~ /MSIE 5\.5/i);
	$br = 'IE6'            if ($agent =~ /MSIE 6/i);
	$br = 'OldIE'          if ($agent =~ /MSIE/i and $br eq '');
	$br = 'IE?'            if ($br eq '' and $agent eq '*Internet Explorer');
	$br = 'Safari'         if ($agent =~ /Safari/);
	$br = 'OmniWeb'        if ($agent =~ /OmniWeb/);	# by GLM
	$br = 'Shiira'         if ($agent =~ /Shiira/);	# by GLM
	$br = 'Firefox'        if ($agent =~ /Firefox/ or $agent =~ /Firebird/);
	$br = 'Sylera'         if ($agent =~ /Sylera/);	# by GLM
	$br = 'PSP'            if ($agent =~ /PSP/);	# by GLM
	$br = 'Netscape'       if ($agent =~ /Netscape/);	# by GLM
	$br = 'Opera'          if ($agent =~ /Opera/);
	$br = 'Sleipnir'       if ($agent =~ /Sleipnir/);	# by GLM
	$br = 'Sleipnir2'      if ($agent =~ /Sleipnir\/2/);	# by GLM
	$br = 'Lunascape'      if ($agent =~ /Lunascape/);	# by GLM
	$br = 'Lunascape3'     if ($agent =~ /Lunascape 3/);	# by GLM
	$br = 'iCab'           if ($agent =~ /iCab/);	# by GLM
	$br = 'Camino'         if ($agent =~ /Camino/);	# by GLM
	$br = 'DoCoMo'         if ($agent =~ /DoCoMo/);	# by GLM
	$br = 'jig browser'    if ($agent =~ /jig browser/);	# by GLM
	$br = 'Blazer'         if ($agent =~ /Blazer/);	# by GLM
	$br = 'Xiino'          if ($agent =~ /Xiino/);	# by GLM
	$br = 'NetFront'       if ($agent =~ /NetFront/);	# by GLM
	$br = 'Mozilla Series' if ($br eq '' and $agent =~ /Gecko/);
	$br = 'OldNN'          if ($os eq 'Linux' and $br eq '' and $agent =~ /Mozilla/);
	$os = 'PDA'            if (($br eq 'Blazer') || ($br eq 'Netfront') || ($br eq 'Xiino') || ($agent =~ /Sigmarion3/));	# by GLM
	$os = 'Mobile'         if (($br eq 'DoCoMo') || ($br eq 'jig browser') || ($br eq 'PSP'));	# by GLM
	$agent = 'Blocked'     if ($agent =~ /0{6,}/);	# by GLM
	$br = 'IE Component'   if ($br eq 'OldIE' and ($os eq 'WinXP' or $os eq 'Win2K'));
	$agent = $os . ' : ' . $br if ($os and $br);	# by GLM
	return($agent);
}
sub _abstract_termlog {
	my $self = shift;
	my $items = shift;
	my $termdate = shift;
	my $termstart = shift;
	my $termend = shift;
	my $zone = shift;
	my $cm_antenna = shift;
	my $count = 0;
	my $surplus = 0;
	my @out = ();
	my @logs = ();
	my $termyear = int(substr($termdate,0,4));
	my $termmonth = int(substr($termdate,4,2));
	my $termday = int(substr($termdate,6,2));
	my ($ytermday, $ytermmonth, $ytermyear) = &_get_yesterday(&_get_timegm($termyear, $termmonth - 1, $termday, 0) - $zone,$zone);
	my $ytermdate = $ytermyear . &_pad0($ytermmonth) . &_pad0($ytermday);
	my $conf = sb::Config->get;
	my $path = $conf->value('dir_data') . $conf->value('dir_access') . $ytermdate . $conf->value('file_suf');
	if(-e $path) {
		open(LOGIN,"<$path");
		push(@logs,<LOGIN>);
		close(LOGIN);
	}
	my $path = $conf->value('dir_data') . $conf->value('dir_access') . $termdate . $conf->value('file_suf');
	if(-e $path) {
		open(LOGIN,"<$path");
		push(@logs,<LOGIN>);
		close(LOGIN);
	}
	@logs = reverse(@logs);
	foreach my $log (@logs){
		my @elem = split(/\t/,$log);
		$elem[0] = int($elem[0]);
		if($elem[0] < $termstart) {
			last;
		} elsif($elem[0] >= $termend) {
			 next;
		} else {
			if($count >= $items) {
				$surplus++;
			} else {
				my @tbuf = gmtime($elem[0] + $zone);
				my $date = ($tbuf[5] + 1900) . '/' .  &_pad0($tbuf[4] + 1) . '/' .  &_pad0($tbuf[3]) . '<br />' . &_pad0($tbuf[2]) . ':' . &_pad0($tbuf[1]) . ':' . &_pad0($tbuf[0]);
				my $host = $elem[2];
				$host .= '<br />' if($elem[2] ne '');
				$host .= '(' . $elem[1] . ')' if($elem[1] ne '');
				my $agent = &_convert_agent($elem[4]) . '<br />';
				my $refs = $elem[6];
				if ( index($refs,$conf->value('conf_srv_cgi')) > -1 
				  or index($refs,$conf->value('conf_srv_base')) > -1) {
					$refs = '';
				}
				$refs =~ s/^(.*?)\?$/$1/;
				$refs =~ s/^(.*?)\?[0-9]{8,10}$/$1/ if($cm_antenna eq '1');
				if($refs =~ /(.*?)admin.cgi/) {
					$refs = $1;
				}
				$refs = &_set_link($refs) if($refs ne '');
				$refs .= '<br />';
				push(@out, $date . '<>' . $host . '<>' . $agent . '<>' . $refs . '<>');
				$count++;
			}
		}
	}
	my $loglen = @logs;
	if ($loglen == 0) {
		$self->{'log_deleted'} = '1';
	}
	$self->{'log_items'} = $count;
	$self->{'log_surplus'} = $surplus;
	return(@out);
}
sub _abstract_log {
	my $self = shift;
	my $items = shift;
	my $zone = shift;
	my $cm_antenna = shift;
	my @files = @_;
	$items = int($items);
	my $count = 0;
	my @out = ();
	my $conf = sb::Config->get;
	my $dir = $conf->value('dir_data') . $conf->value('dir_access');
	OUTER: foreach my $file (@files) {
		my $path = $dir . $file;
		open(LOGIN,"<$path") or next;
		my @logs = <LOGIN>;
		close(LOGIN);
		@logs = reverse(@logs);
		foreach my $log (@logs){
			if($count >= $items) {
				last OUTER;
			}
			my @elem = split(/\t/,$log);
			my @tbuf = gmtime($elem[0] + $zone);
			my $date = ($tbuf[5] + 1900) . '/' .  &_pad0($tbuf[4] + 1) . '/' .  &_pad0($tbuf[3]) . '<br />' . &_pad0($tbuf[2]) . ':' . &_pad0($tbuf[1]) . ':' . &_pad0($tbuf[0]);
			my $host = $elem[2];
			$host .= '<br />' if($elem[2] ne '');
			$host .= '(' . $elem[1] . ')' if($elem[1] ne '');
			my $agent = &_convert_agent($elem[4]) . '<br />';
			my $refs = $elem[6];
			if ( index($refs,$conf->value('conf_srv_cgi')) > -1 
			  or index($refs,$conf->value('conf_srv_base')) > -1) {
				$refs = '';
			}
			$refs =~ s/^(.*?)\?$/$1/;
			$refs =~ s/^(.*?)\?[0-9]{8,10}$/$1/ if($cm_antenna eq '1');
			if($refs =~ /(.*?)admin.cgi/) {
				$refs = $1;
			}
			$refs = &_set_link($refs) if($refs ne '');
			$refs .= '<br />';
			push(@out, $date . '<>' . $host . '<>' . $agent . '<>' . $refs . '<>');
			$count++;
		}
	}
	$self->{'log_items'} = $count;
	return(@out);
}
sub _analyze_log {
	my $self = shift;
	my $sttoday = shift;
	my $stweek = shift;
	my $cm_antenna = shift;
	my @files = @_;
	my %state = (
		'reftoday' => {},
		'refweek' => {},
	);

	my $count_refweek = 0;
	my $count_reftoday = 0;
	my $conf = sb::Config->get;
	my $dir = $conf->value('dir_data') . $conf->value('dir_access');
	OUTER: foreach my $file (@files) {
		my $path = $dir . $file;
		open(LOGIN,"<$path") or next;
		while (my $line = <LOGIN>) {
			my @elem = ($line =~ /(.*?)\t/g);
			my $date = $elem[0];
			if($date < $stweek) {
				close(LOGIN);
				last OUTER;
			}
			my $refs = $elem[6] if ($elem[6] ne '');
			if ( index($refs,$conf->value('conf_srv_cgi')) > -1 
			  or index($refs,$conf->value('conf_srv_base')) > -1) {
				$refs = '';
			}
			foreach my $engine (keys %mEngines) {
				if ($refs =~ /$engine/) {
					$refs = $mEngines{$engine}{'name'};
					last;
				}
			}
			$refs =~ s/^(.*?)\?$/$1/;
			$refs =~ s/^(.*?)\?[0-9]{8,10}$/$1/ if($cm_antenna eq '1');
			if($refs =~ /(.*?)admin.cgi/) {
				$refs = $1;
			}
			$state{'reftoday'}{$refs}++ if(($refs ne '') && ($date >= $sttoday));
			$state{'refweek'}{$refs}++ if ($refs ne '');
			$count_refweek++;
			$count_reftoday++ if($date >= $sttoday);
		}
		close(LOGIN);
	}
	$self->{'count_refweek'} = $count_refweek;
	$self->{'count_reftoday'} = $count_reftoday;
	return(%state);
}
sub _set_link {
	my $uri = shift;
	return($uri) if($uri eq 'blockedReferrer');
	my $res = '<a href="' . $uri . '" title="' . $uri . '" target="_blank">' . sb::Text->clip('text'=>$uri,'length'=>45) . '</a>';
	return($res);
}
sub _display_refs {	# from YetAnotherAccessLog.pm
	my $self = shift;
	my $text = shift;
	return $text if ($text =~ /^<a /);

	$text = sb::Text->entitize($text);
	return $self->_display_elements('mode'=>'refs','text'=>$text);
}
sub _get_timegm {
	my $year = shift;
	my $mon = shift;
	my $mday = shift;
	my $hours = shift;
	my $zone = shift;
	use Time::Local;
	return(timegm(0, 0, $hours, $mday, $mon, $year));
}
sub _starttime {
	my $date = shift;
	my $zone = shift;
	my ($mday, $mon, $year) = (gmtime($date + $zone))[3,4,5];
	$year += 1900;

	my $starttoday = &_get_timegm($year, $mon, $mday, 0) - $zone;
	my $startaweek = $starttoday - 6 * 24 * 60 * 60;

	if(($date - $starttoday) < 0.5 * 24 * 60 * 60) {
		($mday, $mon, $year) = &_get_yesterday($date,$zone);
		$starttoday = &_get_timegm($year, $mon - 1, $mday, 12) - $zone;
	}
	return($starttoday,$startaweek);
}
sub _get_yesterday {
	my $date = shift;
	my $zone = shift;
	my ($mday, $mon, $year) = (gmtime($date + $zone))[3,4,5];
	$year += 1900;
	my @mdayend = (31,28,31,30,31,30,31,31,30,31,30,31);
	$mday--;
	if($mday < 1) {
		$mon--;
		if($mon < 0) {
			$year--;
			$mon = 11;
		}
		if(($year % 4 == 0 && $year % 100 != 0) || $year % 400 == 0) { $mdayend[1] = 29; }
		$mday = $mdayend[$mon];
	}
	return($mday, $mon + 1, $year);
}
sub _get_tomorrow {
	my $date = shift;
	my $zone = shift;
	my ($mday, $mon, $year) = (gmtime($date + $zone))[3,4,5];
	$year += 1900;
	my @mdayend = (31,28,31,30,31,30,31,31,30,31,30,31);
	$mday++;
	if(($year % 4 == 0 && $year % 100 != 0) || $year % 400 == 0) { $mdayend[1] = 29; }
	if($mdayend[$mon] < $mday) {
		$mday = 1;
		$mon++;
		if($mon > 11) {
			$year++;
			$mon = 0;
		}
	}
	return($mday, $mon + 1, $year);
}
sub _format_date {
	my $date = shift;
	my $zone = shift;
	my ($mday, $mon, $year) = (gmtime($date + $zone))[3,4,5];
	my $out = sprintf("%04d/%02d/%02d", $year + 1900, $mon + 1, $mday);
	return($out);
}
sub _format_time {
	my $date = shift;
	my $zone = shift;
	my $job = shift;
	my $hour = (gmtime($date + $zone))[2];
	$hour-- if($job eq 'end');
	$hour = 23 if($hour == -1);
	my $format = sb::Language->get->string('parts_ralog_timeordinal');
	my $out = sprintf($format, $hour);
	return($out);
}
sub _pad0 { # padding 0
	return( ($_[0] < 10) ? '0' . $_[0] : $_[0] );
}
sub _load_access {
	my $self = shift;
	my $now = shift;
	my $zone = shift;
	my $job = shift;
	if($job eq 'yesterday') {
		$now -= 86400;
	}
	my $count = 0;
	my @logs = ();
	my $conf = sb::Config->get;
	my ($ymday, $ymon, $yyear) = &_get_yesterday($now,$zone);
	my $path = $conf->value('dir_data') . $conf->value('dir_access') . $yyear . &_pad0($ymon) . &_pad0($ymday) . $conf->value('file_suf');
	open(LOGIN,"<$path");
	push(@logs,<LOGIN>);
	close(LOGIN);
	my ($mday, $mon, $year) = (gmtime($now + $zone))[3,4,5];
	$year += 1900;
	$mon++;
	my $path = $conf->value('dir_data') . $conf->value('dir_access') . $year . &_pad0($mon) . &_pad0($mday) . $conf->value('file_suf');
	open(LOGIN,"<$path");
	push(@logs,<LOGIN>);
	close(LOGIN);
	@logs = reverse(@logs);
	foreach my $log(@logs) {
		my @elem = split(/\t/,$log);
		my @tbuf = gmtime($elem[0] + $zone);
		if(($tbuf[5] + 1900 == $year) && ($tbuf[4] + 1 == $mon) && ($tbuf[3] == $mday)) {
			$count++;
		}
	}
	return($count);
}
1;
__END__
