#!/usr/bin/perl -w
# 
# sb::Plugin::MixedComTbList - Plugin Module for Serene Bach
# - Written by Gin-Lime / published on 2006-05-29
# -- `Serene Bach' is written by T.Otani
# --   Copyright (C) 2005- SimpleBoxes/SerendipityNZ.

package sb::Plugin::MixedComTbList;
# ==================================================
# // initialization for plugin
# ==================================================
use sb::Plugin ();
sb::Plugin->register_plugin(
	'lang' => {
		'ja' => 'euc',
		'en' => 'ascii',
	},
	'text' => {
		'type'    => 'admin, cms',
		'name'    => 'Mixed List',
		'text'    => 'Lists up both comments and trackbacks in one',
		'author'  => 'Gin-Lime',
		'detail'  => 'http://www.emeraldshell.com/sb/',
		'version' => '0.04',
		'publish' => 'yes',	# ץ饰ꥹȤΤγĥʸ/
	},
	'file' => 'mixedcomtblist.txt',
	'data' => 1,
);

# cmsѥץ饰ȤϿ
sb::Plugin->register_content_module(
	'type'     => 'main',
	'callback' => \&sb::Content::MixedComTbList::_mixedlist,
	'field'    => 'mixed_list',
	'name'     => 'MixedComTbList::mixed_list',
);
# adminѥץ饰ȤϿ
sb::Plugin->register_admin_module(
	'mode'   => 'mixedcomtblist',
	'level'  => 1,
	'module' => 'sb::Admin::MixedComTbList',
);

# sb::Plugin::CmsJumpsb::Plugin::ComTbTreesb::Plugin::ComTbCustomList ȶ¸
sub _init {
	my $cmsj = 'CmsJump.pm';
	my $ctt = 'ComTbTree.pm';
	my $ctcl = 'ComTbCustomList.pm';
	if((&sb::Plugin::_ignore_plugin($cmsj)) && (&sb::Plugin::_ignore_plugin($ctcl))) {
		my $set_data = sb::Plugin->get_data;
		my @settings = ();
		@settings = split('<>',$set_data->setting);
		my $tb_link = ($settings[0] ne '') ? $settings[0] : &sb::Admin::MixedComTbList::TB_LINK;
		if($tb_link eq '0') {
			sb::Plugin->register_content_module(
				'type'     => 'trackback',
				'callback' => \&sb::Content::MixedComTbList::_add_id_to_trackback,
				'field'    => 'trackback_id',
				'name'     => 'MixedComTbList::trackback_id'
			);
		}
	}
	if((&sb::Plugin::_ignore_plugin($cmsj)) && (&sb::Plugin::_ignore_plugin($ctt)) && (&sb::Plugin::_ignore_plugin($ctcl))) {
		sb::Plugin->register_content_module(
			'type'     => 'comment',
			'callback' => \&sb::Content::MixedComTbList::_add_id_to_comment,
			'field'    => 'comment_id',
			'name'     => 'MixedComTbList::comment_id'
		);
	}
}
&_init();

package sb::Content::MixedComTbList;
# ==================================================
# // configuration for inheritance / dependancy
# ==================================================
use sb::Config ();
use sb::Data ();
use sb::Plugin ();
use sb::Text ();
use sb::Time ();
use sb::Build ();
use sb::Language ();
use sb::Admin::Config ();
# ==================================================
# // declaration for class member
# ==================================================
my %mListScripts = (
	'mixed_comtb'   => 'mixedlist.js',
	'mixed_bydate'  => 'mixedlist_date.js',
	'mixed_byentry' => 'mixedlist_entry.js',
);
my @mListParent = (
	'<li>%s',
	'<div>%s</div>',
	'<dt>%s</dt>', 
);
my @mListChild = (
	'<li class="branch">%s</li>',
	'<div class="branch">%s</div>',
	'<dd class="branch">%s</dd>', 
);
my @mListChildEnd = (
	'<li class="branch_end">%s</li>',
	'<div class="branch_end">%s</div>',
	'<dd class="branch_end">%s</dd>', 
);
# ==================================================
# // functions for content
# ==================================================
sub _add_id_to_comment {	# from CmsJump.pm _comment_with_id
	my $cms  = shift;
	my $com  = shift;
	# by GLM
	my $set_data = sb::Plugin->get_data;
	my @strings = split('<>',$set_data->text);
	my $com_prefix = ($strings[0] ne '') ? $strings[0] : &sb::Admin::MixedComTbList::COM_PREFIX;
	$com_prefix = sb::Text->detitize($com_prefix);
	# add comment id
	$cms->tag('comment_id'=>$com_prefix . $com->id);
}
sub _add_id_to_trackback {	# from CmsJump.pm _trackback_with_id
	my $cms  = shift;
	my $tb  = shift;
	# by GLM
	my $set_data = sb::Plugin->get_data;
	my @strings = split('<>',$set_data->text);
	my $tb_prefix = ($strings[1] ne '') ? $strings[1] : &sb::Admin::MixedComTbList::TB_PREFIX;
	$tb_prefix = sb::Text->detitize($tb_prefix);
	# add trackback id
	$cms->tag('trackback_id'=>$tb_prefix . $tb->id);
}
sub _mixedlist {
	my $cms = shift;
	my %var = @_;

	if ($var{'mode'} ne 'page' or $var{'page'} !=0){	# ȥåץڡʳ
		&_script_tag('mixed_bydate',$cms);
		&_script_tag('mixed_byentry',$cms);
		return( &_script_tag('mixed_comtb',$cms) );
	} else {
		my $num = 0;

		my $set_data = sb::Plugin->get_data;
		my @settings = split('<>',$set_data->setting);
		my $tb_link = ($settings[0] ne '') ? $settings[0] : &sb::Admin::MixedComTbList::TB_LINK;
		my $tree_style = ($settings[1] ne '') ? $settings[1] : &sb::Admin::MixedComTbList::TREE_STYLE;
		my $tree_end_class = ($settings[2] ne '') ? $settings[2] : &sb::Admin::MixedComTbList::TREE_END_CLASS;
		$tree_style = int($tree_style);
		my @strings = split('<>',$set_data->text);
		my $com_prefix = ($strings[0] ne '') ? $strings[0] : &sb::Admin::MixedComTbList::COM_PREFIX;
		$com_prefix = sb::Text->detitize($com_prefix);
		my $tb_prefix = ($strings[1] ne '') ? $strings[1] : &sb::Admin::MixedComTbList::TB_PREFIX;
		$tb_prefix = sb::Text->detitize($tb_prefix);
		my $com_style = ($strings[2] ne '') ? $strings[2] : &sb::Admin::MixedComTbList::COM_STYLE;
		$com_style = sb::Text->detitize($com_style);
		my $tb_style = ($strings[3] ne '') ? $strings[3] : &sb::Admin::MixedComTbList::TB_STYLE;
		$tb_style = sb::Text->detitize($tb_style);
		my $com_branch = ($strings[4] ne '') ? $strings[4] : &sb::Admin::MixedComTbList::COM_BRANCH;
		$com_branch = sb::Text->detitize($com_branch);
		my $tb_branch = ($strings[5] ne '') ? $strings[5] : &sb::Admin::MixedComTbList::TB_BRANCH;
		$tb_branch = sb::Text->detitize($tb_branch);
		my $date_format = ($strings[6] ne '') ? $strings[6] : &sb::Admin::MixedComTbList::DATE_FORMAT;
		$date_format = sb::Text->detitize($date_format);
		my $com_date = ($strings[7] ne '') ? $strings[7] : &sb::Admin::MixedComTbList::COM_date;
		$com_date = sb::Text->detitize($com_date);
		my $tb_date = ($strings[8] ne '') ? $strings[8] : &sb::Admin::MixedComTbList::TB_date;
		$tb_date = sb::Text->detitize($tb_date);
		my $com_branch_end = ($strings[9] ne '') ? $strings[9] : &sb::Admin::MixedComTbList::COM_BRANCH_END;
		$com_branch_end = sb::Text->detitize($com_branch_end);
		my $tb_branch_end = ($strings[10] ne '') ? $strings[10] : &sb::Admin::MixedComTbList::TB_BRANCH_END;
		$tb_branch_end = sb::Text->detitize($tb_branch_end);
		my $com_date_end = ($strings[11] ne '') ? $strings[11] : &sb::Admin::MixedComTbList::COM_DATE_END;
		$com_date_end = sb::Text->detitize($com_date_end);
		my $tb_date_end = ($strings[12] ne '') ? $strings[12] : &sb::Admin::MixedComTbList::TB_DATE_END;
		$tb_date_end = sb::Text->detitize($tb_date_end);

		my %comtb_byentry = ();
		my @comtb_byposted = ();
		my @array = sb::Data->load('Message',
			'sort' => 'date',
			'cond' => {'stat'=>1},
			'order'=> 1,
		);
		my $limit = $var{'conf'}->value('conf_com_disp');
		my $comtb_len = 0;
		foreach my $list ( @array ) {
			my $eid = $list->eid;
			my $entry = sb::Data->load('Entry','id'=>$eid);
			next if (!$entry or $entry->stat == 0 or $entry->acm == 0);
			my $entry_url  = $entry->permalink(
				'cat'=>$var{'cat'},
				'mode'=>'',
				'type'=>$var{'conf'}->value('conf_entry_archive')
			);
			my $id = $list->id;
			my $url = $entry_url . '#' . $com_prefix . $id;
			my $date = int($list->date);
			my $linedat = {
				'type' => 'com',
				'id'   => $id,
				'eid'  => $eid,
				'url'  => $url,
				'name' => $list->auth,
				'date' => $date,
			};
			if($comtb_byentry{$eid} eq '') {
				$comtb_byentry{$eid} = $date;
			} else {
				if($comtb_byentry{$eid} < $date) {
					$comtb_byentry{$eid} = $date;
				}
			}
			push(@comtb_byposted, $linedat);
			$num++;
			$comtb_len++;
			last if ($num == $limit);
		}
		my @array = sb::Data->load('Trackback',
			'sort' => 'date',
			'cond' => {'stat'=>1},
			'order'=> 1,
		);
		$num = 0;
		$limit = $var{'conf'}->value('conf_tb_disp');
		foreach my $list ( @array ) {
			my $eid = $list->eid;
			my $entry = sb::Data->load('Entry','id'=>$eid);
			next if (!$entry or $entry->stat == 0 or $entry->atb == 0);
			my $entry_url = $entry->permalink(
				'cat'=>$var{'cat'},
				'mode'=>'',
				'type'=>$var{'conf'}->value('conf_entry_archive')
			);
			my $url = '';
			my $id = $list->id;
			if($tb_link eq '0') {
				$url = $entry_url . '#' . $tb_prefix . $id;
			} else {
				$url = $list->url;
			}
			my $date = int($list->date);
			my $linedat = {
				'type' => 'tb',
				'id'   => $id,
				'eid'  => $eid,
				'url'  => $url,
				'name' => $list->name,
				'date' => $date,
			};
			if($comtb_byentry{$eid} eq '') {
				$comtb_byentry{$eid} = $date;
			} else {
				if($comtb_byentry{$eid} < $date) {
					$comtb_byentry{$eid} = $date;
				}
			}
			push(@comtb_byposted, $linedat);
			$num++;
			$comtb_len++;
			last if ($num == $limit);
		}
		@comtb_byposted = sort { $b->{'date'} <=> $a->{'date'} } @comtb_byposted;
		my %comtb_date_check = ();
		my %comtb_eid_check = ();
		if($tree_end_class eq '1') {	# ĥ꡼λޤο˷¬
			for(my $i = 0;$i < $comtb_len;$i++) {
				my $obj = $comtb_byposted[$i];
				my $eid = $obj->{'eid'};
				if($comtb_eid_check{$eid} == undef) {
					$comtb_eid_check{$eid} = 0;
				}
				$comtb_eid_check{$eid}++;
				my $titledate = sb::Time->format(
					'time'=>$obj->{'date'},
					'form'=>$date_format,
					'zone'=>$var{'conf'}->value('conf_timezone')
				);
				if($comtb_date_check{$titledate} == undef) {
					$comtb_date_check{$titledate} = 0;
				}
				$comtb_date_check{$titledate}++;
			}
		}
		my $comtb = '';
		my $comtb_date = '';
		my $comtb_eid = '';
		my %comtb_date_count = ();	# ޤο򥫥ȡʼ̡
		my %comtb_eid_count = ();	# ޤο򥫥ȡʵ̡
		if($comtb_len > 0) {
			if($tree_style == 0) {
				$comtb = '<ul>' . "\n";
				$comtb_date = '<ul>' . "\n";
				$comtb_eid = '<ul>' . "\n";
			} elsif($tree_style == 2) {
				$comtb = '<dl>' . "\n";
				$comtb_date = '<dl>' . "\n";
				$comtb_eid = '<dl>' . "\n";
			}
		}
		my %comtb_bydate = ();
		my @bydate = ();
		my %comtb_byeid = ();
		my @byeid = sort { $comtb_byentry{$b} <=> $comtb_byentry{$a} } keys( %comtb_byentry );
		my $arrow = $var{'lang'}->string('parts_arrow');
		for(my $i = 0;$i < $comtb_len;$i++) {
			my $obj = $comtb_byposted[$i];
			my $eid = $obj->{'eid'};
			my $format = ($obj->{'type'} eq 'com') ? $com_style : $tb_style;
			my $entry = sb::Data->load('Entry','id'=>$eid);
			my $title = $entry->subj;
			my $entry_url = $entry->permalink(
				'cat'=>$var{'cat'},
				'mode'=>'',
				'type'=>$var{'conf'}->value('conf_entry_archive')
			);
			my $date = sb::Time->format(
				'time'=>$obj->{'date'},
				'form'=>$var{'conf'}->value('conf_dateinlist'),
				'zone'=>$var{'conf'}->value('conf_timezone')
			);
			my $titledate = sb::Time->format(
				'time'=>$obj->{'date'},
				'form'=>$date_format,
				'zone'=>$var{'conf'}->value('conf_timezone')
			);
			my $parent = $mListParent[$tree_style];
			$comtb .= &_format_list($parent,$format,$title,$entry_url,$arrow,$obj->{'url'},$obj->{'name'},$date);
			$comtb .= '</li>' if($tree_style == 0);
			$comtb .= "\n";
			if($comtb_bydate{$titledate} eq '') {
				push(@bydate,$titledate);
				$comtb_date_count{$titledate} = 0;
				$comtb_bydate{$titledate} = sprintf($parent,$titledate);
				$comtb_bydate{$titledate} .= '<br />' if($tree_style == 0);
				$comtb_bydate{$titledate} .= "\n";
				$comtb_bydate{$titledate} .= '<ul>' if($tree_style == 0);
			}
			$comtb_date_count{$titledate}++;
			if(($tree_end_class eq '1') && ($comtb_date_count{$titledate} == $comtb_date_check{$titledate})) {
				$format = ($obj->{'type'} eq 'com') ? $com_date_end : $tb_date_end;
				my $child = $mListChildEnd[$tree_style];
			} else {
				$format = ($obj->{'type'} eq 'com') ? $com_date : $tb_date;
				my $child = $mListChild[$tree_style];
			}
			my $child_line = &_format_list($child,$format,$title,$entry_url,$arrow,$obj->{'url'},$obj->{'name'},$date) . "\n";
			$comtb_bydate{$titledate} .= $child_line;
			if($comtb_byeid{$eid} eq '') {
				$comtb_eid_count{$eid} = 0;
				my $tmp_entry = '<a href="' . $entry_url . '">' . $title . '</a>';
				$comtb_byeid{$eid} = sprintf($parent,$tmp_entry);
				$comtb_byeid{$eid} .= '<br />' if($tree_style == 0);
				$comtb_byeid{$eid} .= "\n";
				$comtb_byeid{$eid} .= '<ul>' if($tree_style == 0);
			}
			$comtb_eid_count{$eid}++;
			if(($tree_end_class eq '1') && ($comtb_eid_count{$eid} == $comtb_eid_check{$eid})) {
				$format = ($obj->{'type'} eq 'com') ? $com_branch_end : $tb_branch_end;
				$child = $mListChildEnd[$tree_style];
			} else {
				$format = ($obj->{'type'} eq 'com') ? $com_branch : $tb_branch;
				$child = $mListChild[$tree_style];
			}
			my $child_line = &_format_list($child,$format,$title,$entry_url,$arrow,$obj->{'url'},$obj->{'name'},$date) . "\n";
			$comtb_byeid{$eid} .= $child_line;
		}
		my $bydate_len = @bydate;
		for(my $i = 0;$i < $bydate_len;$i++) {
			$comtb_date .= $comtb_bydate{$bydate[$i]};
			if($tree_style == 0) {
				$comtb_date .= '</ul></li>' . "\n";
			}
		}
		my $byeid_len = @byeid;
		for(my $i = 0;$i < $byeid_len;$i++) {
			$comtb_eid .= $comtb_byeid{$byeid[$i]};
			if($tree_style == 0) {
				$comtb_eid .= '</ul></li>' . "\n";
			}
		}
		if($comtb_len > 0) {
			if($tree_style == 0) {
				$comtb .= '</ul>' . "\n";
				$comtb_date .= '</ul>' . "\n";
				$comtb_eid .= '</ul>' . "\n";
			} elsif($tree_style == 2) {
				$comtb .= '</dl>' . "\n";
				$comtb_date .= '</dl>' . "\n";
				$comtb_eid .= '</dl>' . "\n";
			}
			$cms->num(0);
			$cms->tag('mixed_comtb'=>$comtb);
			$cms->tag('mixed_bydate'=>$comtb_date);
			$cms->tag('mixed_byentry'=>$comtb_eid);
			my $dir = sb::Config->get->value('conf_dir_base') . sb::Config->get->value('conf_dir_log');
			my $file = $dir . $mListScripts{'mixed_comtb'};
			&sb::Build::_generate_javascript($file,$comtb);
			$file = $dir . $mListScripts{'mixed_bydate'};
			&sb::Build::_generate_javascript($file,$comtb_date);
			$file = $dir . $mListScripts{'mixed_byentry'};
			&sb::Build::_generate_javascript($file,$comtb_eid);
			return(1);
		} else {
			return(0);
		}
	}
}
# ==================================================
# // private functions - other utilities
# ==================================================
sub _format_list {
	my $line = shift;
	my $format = shift;
	my $title = shift;
	my $entry_url = shift;
	my $arrow = shift;
	my $url = shift;
	my $name = shift;
	my $date = shift;
	my $out = '';
	$format =~ s/\%Title\%/$title/g;
	$format =~ s/\%EntryUrl\%/$entry_url/g;
	$format =~ s/\%Arrow\%/$arrow/g;
	$format =~ s/\%Url\%/$url/;
	$format =~ s/\%Name\%/$name/;
	$format =~ s/\%Date\%/$date/;
	$out = sprintf($line,$format);
	return($out);
}
sub _script_tag {
	my ($key,$cms) = @_;
	my $conf = sb::Config->get;
	my $check = $conf->value('conf_dir_base') . $conf->value('conf_dir_log') . $mListScripts{$key};
	if (-e $check and -s $check) {
		my $script = sprintf(&sb::Build::SCRIPT_TAG,
			sb::Language->get->charset,
			$conf->value('conf_srv_base') . $conf->value('conf_dir_log') . $mListScripts{$key}
		);
		$cms->num(0);
		$cms->tag($key=>$script);
		return(1);
	} else {
		return(0);
	}
}

package sb::Admin::MixedComTbList;
use vars qw( @ISA );
use sb::Interface ();
use sb::TemplateManager ();
use sb::Language ();
use sb::Text ();
@ISA = qw( sb::App::Admin );
# ==================================================
# // declaration for constant value
# ==================================================
sub TEMPLATE    (){ 'mixedcomtblist.html' };
sub DEFAULT_SCREEN (){ 'setting' };
sub TB_LINK     (){ '0' };
sub TREE_STYLE  (){ '0' };
sub TREE_END_CLASS  (){ '0' };
sub COM_PREFIX  (){ 'com' };
sub TB_PREFIX   (){ 'tb' };
sub COM_STYLE   (){ '%Title%&lt;br /&gt;%Arrow% C:&amp;nbsp;&lt;a href=&quot;%Url%&quot;&gt;%Name%%Date%&lt;/a&gt;' };
sub TB_STYLE    (){ '%Title%&lt;br /&gt;%Arrow% T:&amp;nbsp;&lt;a href=&quot;%Url%&quot;&gt;%Name%%Date%&lt;/a&gt;' };
sub COM_BRANCH  (){ '&lt;span class=&quot;com_bullet&quot;&gt;C:&lt;/span&gt;&amp;nbsp;&lt;a href=&quot;%Url%&quot;&gt;%Name%%Date%&lt;/a&gt;' };
sub TB_BRANCH   (){ '&lt;span class=&quot;tb_bullet&quot;&gt;T:&lt;/span&gt;&amp;nbsp;&lt;a href=&quot;%Url%&quot;&gt;%Name%%Date%&lt;/a&gt;' };
sub DATE_FORMAT (){ '%Mon%/%Day%' };
sub COM_DATE  (){ '&lt;span class=&quot;com_bullet&quot;&gt;C:&lt;/span&gt;&amp;nbsp;&lt;a href=&quot;%Url%&quot;&gt;%Name% (%Arrow%%Title%)&lt;/a&gt;' };
sub TB_DATE   (){ '&lt;span class=&quot;tb_bullet&quot;&gt;T:&lt;/span&gt;&amp;nbsp;&lt;a href=&quot;%Url%&quot;&gt;%Name% (%Arrow%%Title%)&lt;/a&gt;' };
sub COM_BRANCH_END  (){ '&lt;span class=&quot;com_bullet&quot;&gt;C:&lt;/span&gt;&amp;nbsp;&lt;a href=&quot;%Url%&quot;&gt;%Name%%Date%&lt;/a&gt;' };
sub TB_BRANCH_END   (){ '&lt;span class=&quot;tb_bullet&quot;&gt;T:&lt;/span&gt;&amp;nbsp;&lt;a href=&quot;%Url%&quot;&gt;%Name%%Date%&lt;/a&gt;' };
sub COM_DATE_END  (){ '&lt;span class=&quot;com_bullet&quot;&gt;C:&lt;/span&gt;&amp;nbsp;&lt;a href=&quot;%Url%&quot;&gt;%Name% (%Arrow%%Title%)&lt;/a&gt;' };
sub TB_DATE_END   (){ '&lt;span class=&quot;tb_bullet&quot;&gt;T:&lt;/span&gt;&amp;nbsp;&lt;a href=&quot;%Url%&quot;&gt;%Name% (%Arrow%%Title%)&lt;/a&gt;' };
# ==================================================
# // public functions - callback
# ==================================================
sub callback {
	my $self = shift;
	return ( $self->{'regi'} ) 
		? $self->_save_setting(@_)
		: $self->_show_setting(@_);
}
# ==================================================
# // private functions - main routine
# ==================================================
sub _save_setting {
	my $self = shift;
	my $cgi  = sb::Interface->get;
	my $lang = sb::Language->get;
	# ǡμ
	my $data = sb::Plugin->get_data;
	my $msg = '';
	if($cgi->value('initialize') ne '') {
		$data->setting(TB_LINK . '<>' . TREE_STYLE . '<>' . TREE_END_CLASS);
		$data->text(COM_PREFIX . '<>' . TB_PREFIX . '<>' . COM_STYLE . '<>' . TB_STYLE . '<>' . COM_BRANCH . '<>' . TB_BRANCH . '<>' . DATE_FORMAT . '<>' . COM_DATE . '<>' . TB_DATE . '<>' . COM_BRANCH_END . '<>' . TB_BRANCH_END . '<>' . COM_DATE_END . '<>' . TB_DATE_END);
		$msg = $lang->string('parts_mctl_initialized');
	} else {
	# μ
		$data->setting($cgi->value('tb_link') . '<>' . $cgi->value('tree_style') . '<>' . $cgi->value('tree_end_class'));
		my $tb_prefix = ($cgi->value('tb_prefix') ne '') ? $cgi->value('tb_prefix') : $cgi->value('tb_prefix_hidden');
		$tb_prefix = sb::Text->entitize($tb_prefix);
		my $com_branch_end = ($cgi->value('com_branch_end') ne '') ? $cgi->value('com_branch_end') : $cgi->value('com_branch_end_hidden');
		$com_branch_end = sb::Text->entitize($com_branch_end);
		my $tb_branch_end = ($cgi->value('tb_branch_end') ne '') ? $cgi->value('tb_branch_end') : $cgi->value('tb_branch_end_hidden');
		$tb_branch_end = sb::Text->entitize($tb_branch_end);
		my $com_date_end = ($cgi->value('com_date_end') ne '') ? $cgi->value('com_date_end') : $cgi->value('com_date_end_hidden');
		$com_date_end = sb::Text->entitize($com_date_end);
		my $tb_date_end = ($cgi->value('tb_date_end') ne '') ? $cgi->value('tb_date_end') : $cgi->value('tb_date_end_hidden');
		$tb_date_end = sb::Text->entitize($tb_date_end);
		$data->text(sb::Text->entitize($cgi->value('com_prefix')) . '<>' . $tb_prefix . '<>' . sb::Text->entitize($cgi->value('com_style')) . '<>' . sb::Text->entitize($cgi->value('tb_style')) . '<>' . sb::Text->entitize($cgi->value('com_branch')) . '<>' . sb::Text->entitize($cgi->value('tb_branch')) . '<>' . sb::Text->entitize($cgi->value('date_format')) . '<>' . sb::Text->entitize($cgi->value('com_date')) . '<>' . sb::Text->entitize($cgi->value('tb_date')) . '<>' . $com_branch_end . '<>' . $tb_branch_end . '<>' . $com_date_end . '<>' . $tb_date_end);
		$msg = $lang->string('parts_confcomp');
		$msg .= $lang->string('parts_rec_make');
		$msg .= sprintf($lang->string('parts_link_bld'),&sb::App::Admin::get_script_path);
	}
	# ǡ¸
	sb::Plugin->set_data('data' => $data);
	# ¸λåɽ
	return $self->_show_setting('screen' => 'setting','message'=>$msg);
}
sub _show_setting {
	my $self = shift;
	my %param = ('screen' => '','message' => '', @_);
	my $cms  = sb::TemplateManager->new(sb::Plugin->load_template('file' => TEMPLATE));
	my $screen = ($param{'screen'} ne '') ? $param{'screen'} : DEFAULT_SCREEN;
	my $cgi  = sb::Interface->get;
	$screen = $cgi->value('__type') if($cgi->value('__type') ne '');
	if($screen eq 'setting') {	# ξ
		my $set_data = sb::Plugin->get_data;
		my @settings = split('<>',$set_data->setting);
		my $tb_link = ($settings[0] ne '') ? $settings[0] : TB_LINK;
		my $tree_style = ($settings[1] ne '') ? $settings[1] : TREE_STYLE;
		my $tree_end_class = ($settings[2] ne '') ? $settings[2] : TREE_END_CLASS;
		my @strings = split('<>',$set_data->text);
		my $com_prefix = ($strings[0] ne '') ? $strings[0] : COM_PREFIX;
		my $tb_prefix = ($strings[1] ne '') ? $strings[1] : TB_PREFIX;
		my $com_style = ($strings[2] ne '') ? $strings[2] : COM_STYLE;
		my $tb_style = ($strings[3] ne '') ? $strings[3] : TB_STYLE;
		my $com_branch = ($strings[4] ne '') ? $strings[4] : COM_BRANCH;
		my $tb_branch = ($strings[5] ne '') ? $strings[5] : TB_BRANCH;
		my $date_format = ($strings[6] ne '') ? $strings[6] : DATE_FORMAT;
		my $com_date = ($strings[7] ne '') ? $strings[7] : COM_DATE;
		my $tb_date = ($strings[8] ne '') ? $strings[8] : TB_DATE;
		my $com_branch_end = ($strings[9] ne '') ? $strings[9] : COM_BRANCH_END;
		my $tb_branch_end = ($strings[10] ne '') ? $strings[10] : TB_BRANCH_END;
		my $com_date_end = ($strings[11] ne '') ? $strings[11] : COM_DATE_END;
		my $tb_date_end = ($strings[12] ne '') ? $strings[12] : TB_DATE_END;
		my $arrow = sb::Language->get->string('parts_arrow');
		# ȼͤ
		$cms->num(0);
		$cms->tag('sb_mctl_tb_link_0' => ($tb_link eq '0') ? ' selected' : '' );
		$cms->tag('sb_mctl_tb_link_1' => ($tb_link eq '1') ? ' selected' : '' );
		$cms->tag('sb_mctl_tree_style_0' => ($tree_style eq '0') ? ' selected' : '' );
		$cms->tag('sb_mctl_tree_style_1' => ($tree_style eq '1') ? ' selected' : '' );
		$cms->tag('sb_mctl_tree_style_2' => ($tree_style eq '2') ? ' selected' : '' );
		$cms->tag('sb_mctl_tree_end_class_0' => ($tree_end_class eq '0') ? ' selected' : '' );
		$cms->tag('sb_mctl_tree_end_class_1' => ($tree_end_class eq '1') ? ' selected' : '' );
		$cms->tag('sb_mctl_com_prefix' => $com_prefix );
		$cms->tag('sb_mctl_tb_prefix' => $tb_prefix );
		$cms->tag('sb_mctl_tb_prefix_hidden' => $tb_prefix );
		$cms->tag('sb_mctl_com_style' => $com_style );
		$cms->tag('sb_mctl_tb_style' => $tb_style );
		$cms->tag('sb_mctl_com_branch' => $com_branch );
		$cms->tag('sb_mctl_tb_branch' => $tb_branch );
		$cms->tag('sb_mctl_date_format' => $date_format );
		$cms->tag('sb_mctl_com_date' => $com_date );
		$cms->tag('sb_mctl_tb_date' => $tb_date );
		$cms->tag('sb_mctl_com_branch_end' => $com_branch_end );
		$cms->tag('sb_mctl_tb_branch_end' => $tb_branch_end );
		$cms->tag('sb_mctl_com_date_end' => $com_date_end );
		$cms->tag('sb_mctl_tb_date_end' => $tb_date_end );
		$cms->tag('sb_mctl_com_branch_end_hidden' => $com_branch_end );
		$cms->tag('sb_mctl_tb_branch_end_hidden' => $tb_branch_end );
		$cms->tag('sb_mctl_com_date_end_hidden' => $com_date_end );
		$cms->tag('sb_mctl_tb_date_end_hidden' => $tb_date_end );
		$cms->tag('sb_mctl_arrow' => $arrow );
	}
	# åɽ
	if ($param{'message'} ne '') {
		$cms->tag('sb_process_message' => $param{'message'});
		$cms->block('sb_process_message' => 1);
	}
	$cms->tag('sb_mctl_menu_' . $screen => 'class="current"');
	$cms->block('sb_mctl_' . $screen => 1);

	# ̤ɽ
	return sb::Interface->get->head('type'=>'text/html') . $self->set_main($cms->output);
}
1;
# require 뤿Τޤʤ
__END__
