#!/usr/bin/perl -w
# 
# sb::Plugin::MaintenanceLink - Plugin Module for Serene Bach
# - Written by Gin-Lime / published on 2006-03-29
# -- `Serene Bach' is written by T.Otani
# --   Copyright (C) 2005- SimpleBoxes/SerendipityNZ.

package sb::Plugin::MaintenanceLink;
# ==================================================
# // initialization for plugin
# ==================================================
use sb::Plugin ();
sb::Plugin->register_plugin(
	'lang' => {
		'ja' => 'euc',
		'en' => 'ascii',
	},
	'text' => {
		'type'    => 'admin, cms',
		'name'    => 'Maintenance Link',
		'text'    => 'Adds a link for edit mode to an entry.',
		'author'  => 'Gin-Lime',
		'detail'  => 'http://www.emeraldshell.com/sb/',
		'version' => '0.02',
		'publish' => 'yes',	# ץ饰ꥹȤΤγĥʸ/
	},
	'file' => 'maintelink.txt',
	'data' => 1,
);
# cmsѥץ饰ȤϿ
sb::Plugin->register_content_module(
	'type'     => 'entry',
	'callback' => \&sb::Content::MainteLink::_maintelink,
	'field'    => 'maintelink',
);
# adminѥץ饰ȤϿ
sb::Plugin->register_admin_module(
	'mode'   => 'maintelink',
	'level'  => 2,
	'module' => 'sb::Admin::MainteLink',
);
package sb::Content::MainteLink;
# ==================================================
# // declaration for constant value
# ==================================================
sub LINK_FORMAT (){ '<a href="%s"%s>%s</a>' };
# ==================================================
# // functions for content
# ==================================================
use sb::Config ();
use sb::Content ();
use sb::Text ();
use sb::Language ();
sub _maintelink {
	my $cms = shift;
	my $entry = shift;
	my %var = @_;
	my $lang = sb::Language->get;
	my $set_data = sb::Plugin->get_data;
	my $mainte_mark = ($set_data->text ne '') ? sb::Text->detitize($set_data->text) : $lang->string('ml_mainte_string');
	my $mainte_blank = ($set_data->setting ne '') ? $set_data->setting : sb::Admin::MainteLink::MAINTE_BLANK;
	$mainte_blank = ($mainte_blank eq '1') ? ' target="_blank"' : '';
	my $eid = $entry->id;
	my $cgi = $var{'conf'}->value('conf_srv_cgi') . $var{'conf'}->value('basic_admn');
	$cms->tag('mainte_link'=>sprintf(LINK_FORMAT,$cgi . '?__mode=edit&eid=' . $eid,$mainte_blank,$mainte_mark));
	return(1);
}

package sb::Admin::MainteLink;
use sb::Text ();
use vars qw( @ISA );
use sb::Interface ();
use sb::TemplateManager ();
use sb::Language ();
@ISA = qw( sb::App::Admin );
# ==================================================
# // declaration for constant value
# ==================================================
sub TEMPLATE  (){ 'maintelink.html' };
# Խ̤̥ɥɽ뤫
sub MAINTE_BLANK (){ '0' };
# ==================================================
# // public functions - callback
# ==================================================
sub callback {
	my $self = shift;
	return ( $self->{'regi'} ) 
		? $self->_save_setting(@_)
		: $self->_show_setting(@_);
}
# ==================================================
# // private functions - main routine
# ==================================================
sub _save_setting {
	my $self = shift;
	my $cgi  = sb::Interface->get;

	# ǡμ
	my $set_data = sb::Plugin->get_data;

	# μ
	$set_data->text(sb::Text->entitize($cgi->value('mainte_mark')));
	$set_data->setting($cgi->value('mainte_blank'));

	# ǡ¸
	sb::Plugin->set_data('data' => $set_data);

	# ¸λåɽ
	my $lang = sb::Language->get;
	my $msg = $lang->string('parts_confcomp');
	$msg .= $lang->string('parts_rec_make');
	$msg .= sprintf($lang->string('parts_link_bld'),&sb::App::Admin::get_script_path);
	return $self->_show_setting('message'=>$msg);
}
sub _show_setting {
	my $self = shift;
	my %param = ('message' => '', @_);
	my $cms  = sb::TemplateManager->new(sb::Plugin->load_template('file' => TEMPLATE));
	my $lang = sb::Language->get;
	my $set_data = sb::Plugin->get_data;
	my $mainte_mark = ($set_data->text ne '') ? $set_data->text : $lang->string('ml_mainte_string');
	my $mainte_blank = ($set_data->setting ne '') ? $set_data->setting : MAINTE_BLANK;

	# ȼͤ
	$cms->num(0);
	$cms->tag('sb_mainte_blank_0' =>
	          (!$mainte_blank) ? ' selected' : '' );
	$cms->tag('sb_mainte_blank_1' =>
	          ($mainte_blank) ? ' selected' : '' );
	$cms->tag('sb_mainte_mark' => $mainte_mark);

	# åɽ
	if ($param{'message'} ne '') {
		$cms->num(0);
		$cms->tag('sb_process_message' => $param{'message'});
		$cms->block('sb_process_message' => 1);
	}

	# ̤ɽ
	return sb::Interface->get->head('type'=>'text/html') . $self->set_main($cms->output);
}
1;
# require 뤿Τޤʤ
__END__

