#!/usr/bin/perl -w
# 
# sb::Plugin::LumpFormat - Plugin Module for Serene Bach
# - Written by Gin-Lime / published on 2006-03-14
# -- `Serene Bach' is written by T.Otani
# --   Copyright (C) 2005- SimpleBoxes/SerendipityNZ.

package sb::Plugin::LumpFormat;
# ==================================================
# // initialization for plugin
# ==================================================
use sb::Plugin ();
sb::Plugin->register_plugin(
	'lang' => {
		'ja' => 'euc',
		'en' => 'ascii',
	},
	'text' => {
		'type'    => 'admin',
		'name'    => 'LumpFormat',
		'text'    => 'Changes format of entries in a lump',
		'author'  => 'Gin-Lime',
		'detail'  => 'http://www.emeraldshell.com/sb/',
		'version' => '0.04',
		'publish' => 'yes',	# ץ饰ꥹȤΤγĥʸ/
	},
	'file' => 'lumpformat.txt',
	'data' => undef,
);
# adminѥץ饰ȤϿ
sb::Plugin->register_admin_module(
	'mode'   => 'lumpformat',
	'level'  => 2,
	'module' => 'sb::Admin::LumpFormat',
);

package sb::Admin::LumpFormat;
use sb::Text ();
use sb::Plugin ();
use sb::Data ();
use vars qw( @ISA );
use sb::Interface ();
use sb::TemplateManager ();
use sb::Language ();
use sb::Admin::List ();
@ISA = qw( sb::Admin::List );
# ==================================================
# // declaration for constant value
# ==================================================
sub TEMPLATE  (){ 'lumpformat.html' };
# ==================================================
# // public functions - callback
# ==================================================
sub callback {
	my $self = shift;
	return ( $self->{'regi'} ) 
		? $self->_change_format(@_)
		: $self->_show_ui(@_);
}
# ==================================================
# // private functions - main routine
# ==================================================
sub _change_format {
	my $self = shift;
	my $cgi  = sb::Interface->get;

	# μ
	my $format_target = $cgi->value('format_target');	# ѹо
	my $target_format = $cgi->value('target_format');	# $format_target  0 ξоݥեޥå
	my $target_category = $cgi->value('target_category');	# $format_target  1 ξоݥƥ꡼
	my $sub_category = $cgi->value('sub_category');	# $format_target  1 ξΥ֥ƥ꡼ν
	my $changed_format = $cgi->value('changed_format');	# ѹΥեޥå

	# եޥåѹ
	my @entries = sb::Data->load('Entry', 'detail' => 'on');
	if($format_target eq '1') {	# ƥ꡼оݤ˥եޥåѹ
		if(($target_category eq 'all') || ($target_category eq 'except_none') || ($target_category eq 'none')) {
			foreach my $entry (@entries) {
				next if (($target_category eq 'except_none') && ($entry->cat eq ''));
				next if (($target_category eq 'none') && ($entry->cat ne ''));
				$entry->form($changed_format);
				sb::Data->update($entry);
			}
		} else {
			# ƥ꡼ꤹ
			my @cats_2_c = ();
			$cats_2_c[0] = $target_category;
			$self->{'cat'} = { sb::Data->load_as_hash('Category') } unless (defined($self->{'cat'}));
			my @categories = sort { $a->order <=> $b->order } values(%{$self->{'cat'}});
			if(($sub_category eq '1') && ($categories[$target_category]->sub ne '')) {
				my $cat2c_len = @cats_2_c;
				for (my $i=0; $i<$cat2c_len; $i++){
					my $tmpind = int($cats_2_c[$i]);
					next if($categories[$tmpind]->sub eq '');
					my @subs = split(/\,/, $categories[$tmpind]->sub);
					foreach my $sub (@subs) {
						push(@cats_2_c,$sub) if ($sub ne '');
					}
					$cat2c_len = @cats_2_c;
				}
			}
			my %cats2c = ();
			foreach my $cat_2_c (@cats_2_c) {
				$cats2c{"$cat_2_c"} = '1';
			}
			foreach my $entry (@entries) {
				next if ($entry->cat eq '');
				my $changeOk = 0;
				if ($cats2c{$entry->cat} eq '1') {
					$changeOk = 1;
				}
				next if (!$changeOk);
				$entry->form($changed_format);
				sb::Data->update($entry);
			}
		}
	} else {	# եޥåȤоݤ˥եޥåѹ
		foreach my $entry (@entries) {
			next if ($entry->form ne $target_format);
			$entry->form($changed_format);
			sb::Data->update($entry);
		}
	}
	# λåɽ
	my $lang = sb::Language->get;
	my $msg = $lang->string('parts_formatChangeDone')  . '<br />';
	$msg .= $lang->string('parts_needmake');
	$msg .= sprintf($lang->string('parts_link_bld'),&sb::App::Admin::get_script_path);
	return $self->_show_ui('message'=>$msg);
}
sub _show_ui {
	my $self = shift;
	my %param = ('message' => '', @_);
	my $cms  = sb::TemplateManager->new(sb::Plugin->load_template('file' => TEMPLATE));
	my $lang = sb::Language->get;

	# ȼͤ
	$cms->num(0);
	# ƥȥեޥå
	# ѹ
	my $selector = '';
	my %filtername = ();
	my @init_filters = split(/\:/, $lang->string('setup_edit_format'));
	my $init_len = @init_filters;
	for(my $i=0;$i<$init_len;$i++) {
		$selector .= '<option value="' . $i . '"';
		$selector .= ' selected="selected"' if ($i == 0);
		$selector .= '>' . $init_filters[$i] . '</option>' . "\n";
		$filtername{"$i"} = '1';
	}
	my @filters  = sb::Plugin->get_text_filter;
	foreach my $name (@filters) {
		$selector .= '<option value="' . $name . '"';
		$selector .= '>' . $name . '</option>' . "\n";
		$filtername{$name} = '1';
	}
	$cms->tag('sb_lumpformat_changed_format'=>$selector);

	# ѹоݤɲʬ
	my @entries = sb::Data->load('Entry', 'detail' => 'on');
	foreach my $entry (@entries) {
		next if ($filtername{$entry->form} eq '1');
		$selector .= '<option value="' . $entry->form . '"';
		$selector .= '>' . $entry->form . '</option>' . "\n";
		$filtername{$entry->form} = '1';
	}
	$cms->tag('sb_lumpformat_target_format'=>$selector);

	# ƥ꡼쥯
	$self->{'cat'} = { sb::Data->load_as_hash('Category') } unless (defined($self->{'cat'}));	# ƥ꡼ǡ
	my @categories = sort { $b->order <=> $a->order } values(%{$self->{'cat'}});
	$selector = '<option value="none">' . sb::Language->get->string('parts_no_cat') . '</option>' . "\n";
	$selector .= $self->category_selector(
		'cat' => \@categories,
	);
	$cms->tag('sb_lumpformat_target_category'=>$selector);
	my $jsCatArray = '';
	$jsCatArray .= "'-','-','-','-'";
	$jsCatArray .= $self->_get_category_order_jsary(
		'cat' => \@categories,
	);
	$cms->tag('sb_lumpformat_categoryIds'=>$jsCatArray);
	@categories = reverse(@categories);
	my @jsCatRes = ();
	foreach my $category (@categories) {
		my $tmpint = int($category->id);
		if ($category->sub ne '') {
			$jsCatRes[$tmpint] = '1';
		} else {
			$jsCatRes[$tmpint] = '0';
		}
	}
	my $tmplen = $#jsCatRes;
	for(my $i=0;$i<=$tmplen;$i++) {
		$jsCatRes[$i] = '0' if($jsCatRes[$i] == undef);
	}
	$jsCatArray = join(',',@jsCatRes);
	$cms->tag('sb_lumpformat_categoryHasChild'=>$jsCatArray);

	# åɽ
	if ($param{'message'} ne '') {
		$cms->num(0);
		$cms->tag('sb_process_message' => $param{'message'});
		$cms->block('sb_process_message' => 1);
	}

	# ̤ɽ
	return sb::Interface->get->head('type'=>'text/html') . $self->set_main($cms->output);
}
# ==================================================
# // private functions - other utilities
# ==================================================
sub _get_category_order_jsary {
	my $self = shift;
	my %param = (
		'cat'    => [],
		'branch' => undef,   
		'main'   => undef,
		'val'    => '%d',
		@_
	);
	my $order = '';
	foreach my $cat ( @{$param{'cat'}} ) {
		next if ($param{'main'} eq '' and $cat->main ne '');
		next if (defined($param{'branch'}) and $cat->main ne $param{'branch'});
		$order .= ",'" . sprintf($param{'val'},$cat->id) . "'";
		if ($cat->sub ne '') {
			$order .= $self->_get_category_order_jsary(
				'cat'    => $param{'cat'},
				'branch' => $cat->id,
				'main'   => $cat->name,
				'val'    => $param{'val'},
			);
		}
	}
	return($order);
}

1;
# require 뤿Τޤʤ
__END__
