#!/usr/bin/perl -w
# 
# sb::Plugin::EraName - Plugin Module for Serene Bach
# - Written by Gin-Lime / published on 2006-04-14
# -- `Serene Bach' is written by T.Otani
# --   Copyright (C) 2005- SimpleBoxes/SerendipityNZ.

package sb::Plugin::EraName;
# ==================================================
# // initialization for plugin
# ==================================================
use sb::Plugin ();
sb::Plugin->register_plugin(
	'lang' => {
		'ja' => 'euc',
		'en' => 'ascii',
	},
	'text' => {
		'type'    => 'admin, extra',
		'name'    => 'Era name format',
		'text'    => 'Adds formats for displaying era name',
		'author'  => 'Gin-Lime',
		'detail'  => 'http://www.emeraldshell.com/sb/',
		'version' => '0.05',
		'publish' => 'yes',	# ץ饰ꥹȤΤγĥʸ/
	},
	'file' => 'eraname.txt',
	'data' => 1,
);
# adminѥץ饰ȤϿ
sb::Plugin->register_admin_module(
	'mode'   => 'eraname',
	'level'  => 2,
	'module' => 'sb::Admin::EraName',
);
# ץ饰ͭ˥С饤ɤ
sub _init {
	my $name = __FILE__;
	$name =~ s/.*[:\/\\](.*)/$1/;
	if(!&sb::Plugin::_ignore_plugin($name)) {
		use sb::Time();
		*sb::Time::_format = \&_format;
	}
}
&_init();
# ==================================================
# // declaration for constant value
# ==================================================
sub ERA_EN (){ 'A.D.' };
sub ERA_FR (){ 'ap.J-C' };
# ==================================================
# // declaration for class member
# ==================================================
my $mKansuujiNijuu    = '';
# ==================================================
# // function override
# ==================================================
use sb::Time ();
use sb::Language ();
sub _format {
	my %param = @_;              # input parameter
	my $output = $param{'form'}; # output parameter
	my $zone = &sb::Time::_zone($param{'zone'}); # time zone
	my $lang = sb::Language->get();    # get a language instance
	my $set_data = sb::Plugin->get_data;
	my @settings = ();
	@settings = split('<>',$set_data->setting);
	my $kansuuji_type_flag = ($settings[0] ne '') ? $settings[0] : &sb::Admin::EraName::KANSUUJI_TYPE;
	my $ampm_style = ($settings[1] ne '') ? $settings[1] : &sb::Admin::EraName::AMPM_STYLE;
	$mKansuujiNijuu = ($settings[2] ne '') ? $settings[2] : &sb::Admin::EraName::KANSUUJI_NIJUU;
	$kansuuji_type = ($kansuuji_type_flag eq '0') ? 'kanji' : 'honji';
	if ($param{'time'} and $param{'form'}) {
		my ($se,$mi,$ho,$md,$mo,$ye,$wd,$yd,$is) = gmtime($param{'time'} + $zone);
		my $year = $ye + 1900;
		if (index($output,'%Year') > -1) { # Year
			my $tmp = my $tmp2 = $year;
			$output =~ s/%Year%/$tmp/g;
			$tmp = &_era($param{'lang'},$tmp2,$mo + 1,$md,'',1,$tmp2);
			$output =~ s/%YearEx%/$tmp/g;
			$tmp = &_int_to_kansuuji_stay($param{'lang'},$tmp2,$kansuuji_type_flag,$tmp2);
			$output =~ s/%YearLongEx2%/$tmp/g;
			$tmp = &_era($param{'lang'},$tmp2,$mo + 1,$md,'',0,$tmp2);
			$output =~ s/%YearLong%/$tmp/g;
			$tmp = &_era($param{'lang'},$tmp2,$mo + 1,$md,$kansuuji_type,0,$tmp2);
			$output =~ s/%YearLongEx%/$tmp/g;
			$tmp = &sb::Time::_pad0(($ye + 1900) % 100);
			$output =~ s/%YearShort%/$tmp/g;
			$tmp = &_era($param{'lang'},$tmp2,$mo + 1,$md,$kansuuji_type,1,$tmp);
			$output =~ s/%YearShortEx%/$tmp/g;
		}
		if (index($output,'%Mon') > -1) { # Month
			my $tmp = &sb::Time::_pad0($mo + 1);
			$tmp = $lang->string('month_' . $param{'lang'})->[$mo] if (ref($lang->string('month_' . $param{'lang'})) eq 'ARRAY');
			$output =~ s/%MonShort%/$tmp/g;
			$tmp = my $tmp2 = $lang->string('month_' . $param{'lang'} . 'long')->[$mo] if (ref($lang->string('month_' . $param{'lang'} . 'long')) eq 'ARRAY');
			$output =~ s/%MonLong%/$tmp/g;
			$tmp = $mo + 1;
			$output =~ s/%MonNumShort%/$tmp/g;
			$output =~ s/%MonNum%/$tmp/g;
			$tmp = &_num_kanji_lang_check($param{'lang'},$tmp,$kansuuji_type_flag,$tmp2);
			$output =~ s/%MonLongEx%/$tmp/g;
			$tmp = &_int_to_kansuuji_stay($param{'lang'},$mo + 1,$kansuuji_type_flag,$mo + 1);
			$output =~ s/%MonLongEx2%/$tmp/g;
			$tmp = &sb::Time::_pad0($mo + 1);
			$output =~ s/%MonNumLong%/$tmp/g;
			$output =~ s/%MonNumPad%/$tmp/g;
			$output =~ s/%Mon%/$tmp/g;
		}
		if (index($output,'%Day') > -1) { # Day
			my $tmp = $md . &sb::Time::_nsuf($md);
			$output =~ s/%DayOrd%/$tmp/g;
			$tmp = $md;
			$output =~ s/%DayShort%/$tmp/g;
			$tmp = &_int_to_kansuuji_stay($param{'lang'},$tmp,$kansuuji_type_flag,$tmp);
			$output =~ s/%DayLongEx2%/$tmp/g;
			$tmp = &sb::Time::_pad0($md);
			$output =~ s/%DayLong%/$tmp/g;
			$output =~ s/%DayPad%/$tmp/g;
			$output =~ s/%Day%/$tmp/g;
			$tmp = &_num_kanji_lang_check($param{'lang'},$md,$kansuuji_type_flag,$tmp);
			$output =~ s/%DayLongEx%/$tmp/g;
		}
		if ((index($output,'%Week') > -1) || (index($output,'%Holiday') > -1)) { # Week
			my $tmp = '';
			$tmp = my $week_short = $lang->string('week_' . $param{'lang'})->[$wd] if ( ref($lang->string('week_' . $param{'lang'})) eq 'ARRAY' );
			$output =~ s/%WeekShort%/$tmp/g;
			$output =~ s/%Week%/$tmp/g;
			$tmp = my $week_long = $lang->string('week_' . $param{'lang'} . 'long')->[$wd] if ( ref($lang->string('week_' . $param{'lang'} . 'long')) eq 'ARRAY' );
			$output =~ s/%WeekLong%/$tmp/g;
			my $holidays = sb::Language->get->holiday($year);
			my $this_date = '' . &sb::Time::_pad0($mo + 1) . &sb::Time::_pad0($md);
			my $holidayname = $holidays->{$this_date};
			my $week_span = lc($lang->string('week_en')->[$wd]);
			my $holiday_span = '';
			if($holidayname ne '') {
				if($param{'lang'} eq 'ja') {
					if($holidayname =~ //) {
						$week_short = '';
						$week_long = '';
					} else {
						$week_short = '';
						$week_long = '';
					}
				}
				$week_span = 'hol';
				$holiday_span = '<span class="week_hol">' . $holidayname . '</span>';
			}
			$output =~ s/%WeekEx%/$week_short/g;
			$output =~ s/%WeekLongEx%/$week_long/g;
			$output =~ s/%HolidayName%/$holidayname/g;
			$output =~ s/%HolidayName2%/$holiday_span/g;
			$tmp = '<span class="week_' . $week_span . '">' . $week_short . '</span>';
			$output =~ s/%WeekEx2%/$tmp/g;
			$tmp = '<span class="week_' . $week_span . '">' . $week_long . '</span>';
			$output =~ s/%WeekLongEx2%/$tmp/g;
		}
		if (index($output,'%Hour') > -1) { # Hour
			my $tmp = my $tmp2 = ($ho < 12) ? &sb::Time::_pad0($ho) : &sb::Time::_pad0($ho - 12);
			$output =~ s/%Hour11%/$tmp/g;
			$tmp = &_num_kanji_lang_check($param{'lang'},$tmp2,$kansuuji_type_flag,$tmp2);
			$output =~ s/%Hour11Ex%/$tmp/g;
			$tmp = &_int_to_kansuuji_stay($param{'lang'},$tmp2,$kansuuji_type_flag,$tmp2);
			$output =~ s/%Hour11Ex2%/$tmp/g;
			$tmp2 = 12 if ($tmp2 == 0);
			$output =~ s/%Hour12%/$tmp2/g;
			$tmp = &_num_kanji_lang_check($param{'lang'},$tmp2,$kansuuji_type_flag,$tmp2);
			$output =~ s/%Hour12Ex%/$tmp/g;
			$tmp = &_int_to_kansuuji_stay($param{'lang'},$tmp2,$kansuuji_type_flag,$tmp2);
			$output =~ s/%Hour12Ex2%/$tmp/g;
			$tmp = &sb::Time::_pad0($ho);
			$output =~ s/%Hour%/$tmp/g;
			$tmp = $tmp2 = $ho;
			$output =~ s/%Hour24%/$tmp/g;
			$tmp = &_num_kanji_lang_check($param{'lang'},$tmp,$kansuuji_type_flag,$ho);
			$output =~ s/%Hour24Ex%/$tmp/g;
			$tmp = &_int_to_kansuuji_stay($param{'lang'},$tmp2,$kansuuji_type_flag,$tmp2);
			$output =~ s/%Hour24Ex2%/$tmp/g;
			$tmp = &_ampm_kanji_lang_check($param{'lang'},$ho,$ampm_style);
			$output =~ s/%HourAP%/$tmp/g;
		}
		if (index($output,'%Min') > -1) { # Minute
			my $tmp = my $tmp2 = &sb::Time::_pad0($mi);
			$output =~ s/%Min%/$tmp/g;
			$tmp = &_num_kanji_lang_check($param{'lang'},$mi,$kansuuji_type_flag,$tmp2);
			$output =~ s/%MinEx%/$tmp/g;
			$tmp = &_int_to_kansuuji_stay($param{'lang'},$mi,$kansuuji_type_flag,$tmp2);
			$output =~ s/%MinEx2%/$tmp/g;
		}
		if (index($output,'%Sec') > -1) { # Second
			my $tmp = my $tmp2 = &sb::Time::_pad0($se);
			$output =~ s/%Sec%/$tmp/g;
			$tmp = &_num_kanji_lang_check($param{'lang'},$se,$kansuuji_type_flag,$tmp2);
			$output =~ s/%SecEx%/$tmp/g;
			$tmp = &_int_to_kansuuji_stay($param{'lang'},$se,$kansuuji_type_flag,$tmp2);
			$output =~ s/%SecEx2%/$tmp/g;
		}
		if (index($output,'%Zone') > -1) { # Time Zone
			my $tmp = $param{'zone'};
			$output =~ s/%Zone%/$tmp/g;
		}
		if (index($output,'%Era') > -1) { # Era Name
			my $tmp = &_era($param{'lang'},$ye + 1900,$mo + 1,$md,'gengou',0);
			$output =~ s/%Era%/$tmp/g;
		}
	}
	return($output);
}

# ==================================================
# // private functions - other utilities
# ==================================================
sub _era {
	my $lang = shift;
	my $year = shift;
	my $month = shift;
	my $day = shift;
	my $style = shift;
	my $numonly = shift;
	my $alternate = shift;
	my $output = '';
	if($lang eq 'ja') {
		$output = &_japanese_era($year,$month,$day,$style,$numonly);
	} else {
		if($lang eq 'en') {
			$output = ERA_EN;
		} elsif($lang eq 'fr') {
			$output = ERA_FR;
		}
		if($numonly) { $output = ''; }
		$output .= $alternate if($style ne 'gengou');
	}
	return($output);
}

sub _ampm_kanji_lang_check {
	my $lang = shift;
	my $hour = shift;
	my $status = shift;
	my $output = '';
	if(($lang eq 'ja') && ($status)) {
		$output = ($hour < 12) ? '' : '';
	} else {
		$output = ($hour < 12) ? 'AM' : 'PM';
	}
	return($output);
}

sub _num_kanji_lang_check {
	my $lang = shift;
	my $num = shift;
	my $status = shift;
	my $alternate = shift;
	my $output = '';
	if($lang eq 'ja') {
		$output = &_int_to_kansuuji($num,$status);
	} else {
		$output = $alternate;
	}
	return($output);
}

sub _japanese_era {
	my $year = shift;
	my $month = shift;
	my $day = shift;
	my $style = shift;
	my $numonly = shift;
	my $output = '';
	my @era_data = ();
	$era_data[0] = '<>1926<>12<>25';
	$era_data[1] = 'ʿ<>1989<>1<>8';

	my $era_length = @era_data;
	my $era = '';
	my $year = $year;
	my $era_set = false;
	for(my $i = 1;$i < $era_length;$i++) {
		my @f_era = split("<>",$era_data[$i-1]);
		my @l_era = split("<>",$era_data[$i]);
		my $l_era_year = int($l_era[1]);
		my $l_era_month = int($l_era[2]);
		my $l_era_day = int($l_era[3]);
		if($year < $l_era_year){
			$era = $f_era[0];
			$year -= (int($f_era[1])-1);
			$era_set = true;
		} elsif($year == $l_era_year) {
			if(($month < $l_era_month) || (($month == $l_era_month) && ($day < $l_era_day))) {
				$era = $f_era[0];
				$year -= (int($f_era[1])-1);
				$era_set = true;
			} else {
				$era = $l_era[0];
				$year -= ($l_era_year-1);
				$era_set = true;
			}
		} else {
			$era = $l_era[0];
			$year -= ($l_era_year-1);
		}
		if($era_set) {
			last;
		}
	}
	if($style eq 'gengou'){
		$output = $era;
	} else {
		if($numonly) {
			$era = '';
		}
		if($style eq 'kanji') {
			$year = &_int_to_kansuuji($year,'0');
		} elsif($style eq 'honji') {
			$year = &_int_to_kansuuji($year,'1');
		}
		$output = $era . $year;
	}
	return($output);
}

sub _int_to_kansuuji (){
	my $num = shift;
	my $status = shift;
	my $output = '';
	my @keta_kanji = ('','','ɴ','','');	# ݤʤΤǡ5 ޤб
	my @keta_kanji_hon = ('','','','','');
	my @suuji_kanji = ('','','','','','','ϻ','','Ȭ','');
	my @suuji_kanji_hon = ('','','','','','','Φ','','','');
	$num = int($num);	# ǰΤ
	$num = "$num";
	my $length = length($num);
	my $count = 0;
	my @tmpoutput = ();
	if($num eq '0') {
		if($status eq '0') {
			$output = '';
		} else {
			$output = '';
		}
	} else {
		for(my $i = $length-1;$i >= 0;$i--) {
			my $figure = int(substr($num, $i, 1));
			my $digchar = '';
			my $fig_res = '';
			if($status eq '0') {
				$fig_res = $suuji_kanji[$figure];
				$digchar = $keta_kanji[$count] if($figure != 0);
			} else {
				$fig_res = $suuji_kanji_hon[$figure];
				$digchar = $keta_kanji_hon[$count] if($figure != 0);
			}
			$fig_res = '' if(($count >= 1) && ($figure == 1));
			unshift(@tmpoutput,$fig_res . $digchar);
			$count++;
		}
		$output = join('' , @tmpoutput);
	}
	if($mKansuujiNijuu eq '1') {
		$output =~ s///;
		$output =~ s///;
		$output =~ s///;
		$output =~ s///;
	} elsif($mKansuujiNijuu eq '2') {
		$output =~ s//װ/;
		$output =~ s//װ/;
		$output =~ s///;
		$output =~ s///;
	}
	return($output);
}

sub _int_to_kansuuji_stay {
	my $lang = shift;
	my $num = shift;
	my $status = shift;
	my $alternate = shift;
	my $output = '';
	if($lang eq 'ja') {
		my @suuji_kanji = ('','','','','','','ϻ','','Ȭ','');
		my @suuji_kanji_hon = ('','','','','','','Φ','','','');
		$num = int($num);	# ǰΤ
		$num = "$num";
		my $length = length($num);
		my @tmpoutput = ();
		for(my $i = $length-1;$i >= 0;$i--) {
			my $figure = int(substr($num, $i, 1));
			if($status eq '0') {
				$figure = $suuji_kanji[$figure];
			} else {
				$figure = $suuji_kanji_hon[$figure];
			}
			unshift(@tmpoutput,$figure);
		}
		$output = join('' , @tmpoutput);
	} else {
		$output = $alternate;
	}
	return($output);
}

package sb::Admin::EraName;
use vars qw( @ISA );
use sb::Interface ();
use sb::TemplateManager ();
@ISA = qw( sb::App::Admin );
# ==================================================
# // declaration for constant value
# ==================================================
sub TEMPLATE  (){ 'eraname.html' };
# ܻ̻ɽ0:̾ʰ󻰡ġ/1:ܻ̻ʰġˡ
sub KANSUUJI_TYPE (){ '0' };
# %HourAP%פɽ0:AM/PM /1:ֻѸפ˽
sub AMPM_STYLE (){ '0' };
# 󽽡סֻפɽ0:󽽡סֻסʡסֻס/1:ס¡פȤ/2:װספȤ
sub KANSUUJI_NIJUU (){ '0' };
# ==================================================
# // public functions - callback
# ==================================================
sub callback {
	my $self = shift;
	return ( $self->{'regi'} ) 
		? $self->_save_setting(@_)
		: $self->_show_setting(@_);
}
# ==================================================
# // private functions - main routine
# ==================================================
sub _save_setting {
	my $self = shift;
	my $cgi  = sb::Interface->get;
	# ǡμ
	my $data = sb::Plugin->get_data;

	# μ
	$data->setting($cgi->value('kansuuji_type') . '<>' . $cgi->value('ampm_style') . '<>' . $cgi->value('kansuuji_nijuu'));

	# ǡ¸
	sb::Plugin->set_data('data' => $data);

	# ¸λåɽ
	my $lang = sb::Language->get;
	my $msg = $lang->string('parts_confcomp');
	$msg .= $lang->string('parts_needmake');
	$msg .= sprintf($lang->string('parts_link_bld'),&sb::App::Admin::get_script_path);
	return $self->_show_setting('message'=>$msg);
}
sub _show_setting {
	my $self = shift;
	my %param = ('message' => '', @_);
	my $cms  = sb::TemplateManager->new(sb::Plugin->load_template('file' => TEMPLATE));
	my $set_data = sb::Plugin->get_data;
	my @settings = ();
	@settings = split('<>',$set_data->setting);
	my $kansuuji_type = ($settings[0] ne '') ? $settings[0] : KANSUUJI_TYPE;
	my $ampm_style = ($settings[1] ne '') ? $settings[1] : AMPM_STYLE;
	my $kansuuji_nijuu = ($settings[2] ne '') ? $settings[2] : KANSUUJI_NIJUU;

	# ȼͤ
	$cms->num(0);
	$cms->tag('sb_eraname_kansuuji_type_0' =>
	          (!$kansuuji_type) ? ' selected' : '' );
	$cms->tag('sb_eraname_kansuuji_type_1' =>
	          ($kansuuji_type) ? ' selected' : '' );
	$cms->tag('sb_eraname_ampm_style_0' =>
	          (!$ampm_style) ? ' selected' : '' );
	$cms->tag('sb_eraname_ampm_style_1' =>
	          ($ampm_style) ? ' selected' : '' );
	$cms->tag('sb_eraname_kansuuji_nijuu_0' =>
	          ($kansuuji_nijuu eq '0') ? ' selected' : '' );
	$cms->tag('sb_eraname_kansuuji_nijuu_1' =>
	          ($kansuuji_nijuu eq '1') ? ' selected' : '' );
	$cms->tag('sb_eraname_kansuuji_nijuu_2' =>
	          ($kansuuji_nijuu eq '2') ? ' selected' : '' );

	# åɽ
	if ($param{'message'} ne '') {
		$cms->num(0);
		$cms->tag('sb_process_message' => $param{'message'});
		$cms->block('sb_process_message' => 1);
	}

	# ̤ɽ
	return sb::Interface->get->head('type'=>'text/html') . $self->set_main($cms->output);
}

1;
# require 뤿Τޤʤ
__END__

Original functions overridden

*sb::Time
Version:0.03

sub _format {
	my %param = @_;              # input parameter
	my $output = $param{'form'}; # output parameter
	my $zone = &_zone($param{'zone'}); # time zone
	my $lang = sb::Language->get();    # get a language instance
	if ($param{'time'} and $param{'form'}) {
		my ($se,$mi,$ho,$md,$mo,$ye,$wd,$yd,$is) = gmtime($param{'time'} + $zone);
		if (index($output,'%Year') > -1) { # Year
			my $tmp = $ye += 1900;
			$output =~ s/%YearLong%/$tmp/g;
			$output =~ s/%Year%/$tmp/g;
			$tmp = &_pad0($ye % 100);
			$output =~ s/%YearShort%/$tmp/g;
		}
		if (index($output,'%Mon') > -1) { # Month
			my $tmp = &_pad0($mo + 1);
			$tmp = $lang->string('month_' . $param{'lang'})->[$mo] if (ref($lang->string('month_' . $param{'lang'})) eq 'ARRAY');
			$output =~ s/%MonShort%/$tmp/g;
			$tmp = $lang->string('month_' . $param{'lang'} . 'long')->[$mo] if (ref($lang->string('month_' . $param{'lang'} . 'long')) eq 'ARRAY');
			$output =~ s/%MonLong%/$tmp/g;
			$tmp = $mo + 1;
			$output =~ s/%MonNumShort%/$tmp/g;
			$output =~ s/%MonNum%/$tmp/g;
			$tmp = &_pad0($mo + 1);
			$output =~ s/%MonNumLong%/$tmp/g;
			$output =~ s/%MonNumPad%/$tmp/g;
			$output =~ s/%Mon%/$tmp/g;
		}
		if (index($output,'%Day') > -1) { # Day
			my $tmp = $md . &_nsuf($md);
			$output =~ s/%DayOrd%/$tmp/g;
			$tmp = $md;
			$output =~ s/%DayShort%/$tmp/g;
			$tmp = &_pad0($md);
			$output =~ s/%DayLong%/$tmp/g;
			$output =~ s/%DayPad%/$tmp/g;
			$output =~ s/%Day%/$tmp/g;
		}
		if (index($output,'%Week') > -1) { # Week
			my $tmp = '';
			$tmp = $lang->string('week_' . $param{'lang'})->[$wd] if ( ref($lang->string('week_' . $param{'lang'})) eq 'ARRAY' );
			$output =~ s/%WeekShort%/$tmp/g;
			$output =~ s/%Week%/$tmp/g;
			$tmp = $lang->string('week_' . $param{'lang'} . 'long')->[$wd] if ( ref($lang->string('week_' . $param{'lang'} . 'long')) eq 'ARRAY' );
			$output =~ s/%WeekLong%/$tmp/g;
		}
		if (index($output,'%Hour') > -1) { # Hour
			my $tmp = ($ho < 12) ? &_pad0($ho) : &_pad0($ho - 12);
			$output =~ s/%Hour11%/$tmp/g;
			$tmp = 12 if ($tmp == 0);
			$output =~ s/%Hour12%/$tmp/g;
			$tmp = &_pad0($ho);
			$output =~ s/%Hour%/$tmp/g;
			$tmp = $ho;
			$output =~ s/%Hour24%/$tmp/g;
			$tmp = ($ho < 12) ? 'AM' : 'PM';
			$output =~ s/%HourAP%/$tmp/g;
		}
		if (index($output,'%Min') > -1) { # Minute
			my $tmp = &_pad0($mi);
			$output =~ s/%Min%/$tmp/g;
		}
		if (index($output,'%Sec') > -1) { # Second
			my $tmp = &_pad0($se);
			$output =~ s/%Sec%/$tmp/g;
		}
		if (index($output,'%Zone') > -1) { # Time Zone
			my $tmp = $param{'zone'};
			$output =~ s/%Zone%/$tmp/g;
		}
	}
	return($output);
}

