#!/usr/bin/perl -w
# 
# sb::Plugin::ComTbCustomList - Plugin Module for Serene Bach
# - Written by Gin-Lime / published on 2006-05-29
# -- `Serene Bach' is written by T.Otani
# --   Copyright (C) 2005- SimpleBoxes/SerendipityNZ.

package sb::Plugin::ComTbCustomList;
# ==================================================
# // initialization for plugin
# ==================================================
use sb::Plugin ();
sb::Plugin->register_plugin(
	'lang' => {
		'ja' => 'euc',
		'en' => 'ascii',
	},
	'text' => {
		'type'    => 'admin, cms',
		'name'    => 'Comment & Trackback List Custom Format',
		'text'    => 'Customize comment list & trackback list',
		'author'  => 'Gin-Lime',
		'detail'  => 'http://www.emeraldshell.com/sb/',
		'version' => '0.03',
		'publish' => 'yes',	# ץ饰ꥹȤΤγĥʸ/
	},
	'file' => 'comtbcustomlist.txt',
	'data' => 1,
);
# admin ѥץ饰ȤϿ
sb::Plugin->register_admin_module(
	'mode'   => 'comtbcustomlist',
	'level'  => 1,
	'module' => 'sb::Admin::ComTbCustomList',
);
# cms ѥץ饰ȤϿ
sb::Plugin->register_content_module(
	'type'     => 'comment',
	'callback' => \&sb::Content::ComTbCustomList::_add_id_to_comment,
	'field'    => 'comment_id',
	'name'     => 'ComTbCustomList::comment_id'
);
my $set_data = sb::Plugin->get_data;
if($set_data->setting eq '0') {
	sb::Plugin->register_content_module(
		'type'     => 'trackback',
		'callback' => \&sb::Content::ComTbCustomList::_add_id_to_trackback,
		'field'    => 'trackback_id',
		'name'     => 'ComTbCustomList::trackback_id'
	);
}
# ץ饰ͭ˥С饤ɤ
sub _init {
	my $name = __FILE__;
	$name =~ s/.*[:\/\\](.*)/$1/;
	if(!&sb::Plugin::_ignore_plugin($name)) {
		use sb::Content();
		*sb::Content::_list_comment = \&_list_comment;
		*sb::Content::_list_trackback = \&_list_trackback;
	}
}
&_init();
# ==================================================
# // function override
# ==================================================
use sb::Data ();
use sb::Text ();
use sb::Time ();
sub _list_comment { # ȥꥹ from sb::Content
	my $cms = shift;
	my %var = @_;
	my $num = 0;
	my @linklist = ('<ul>');
	# by GLM
	my $set_data = sb::Plugin->get_data;
	my @strings = split('<>',$set_data->text);
	my $com_prefix = ($strings[0] ne '') ? $strings[0] : &sb::Admin::ComTbCustomList::COM_PREFIX;
	$com_prefix = sb::Text->detitize($com_prefix);
	my $com_style = ($strings[2] ne '') ? $strings[2] : &sb::Admin::ComTbCustomList::COM_STYLE;
	$com_style = sb::Text->detitize($com_style);
	my $arrow = $var{'lang'}->string('parts_arrow');

	my @array = sb::Data->load('Message',
		'sort' => 'date',
		'cond' => {'stat'=>1},
		'order'=> 1,
	);
	foreach my $list ( @array ) {
		my $entry = sb::Data->load('Entry','id'=>$list->eid);
		next if (!$entry or $entry->stat == 0 or $entry->acm == 0);
		my $entry_url  = $entry->permalink(
			'cat'=>$var{'cat'},
			'mode'=>'',
			'type'=>$var{'conf'}->value('conf_entry_archive')
		);
		my $id = $list->id;	# by GLM
		my $url = $entry_url . '#' . $com_prefix . $id;	# by GLM
		my $subj = $entry->subj;
		my $date = sb::Time->format(
			'time'=>$list->date,
			'form'=>$var{'conf'}->value('conf_dateinlist'),
			'zone'=>$var{'conf'}->value('conf_timezone')
		);
		my $author = $list->auth;
		my $listline = &sb::Plugin::ComTbCustomList::_format_list('<li>%s</li>',$com_style,$subj,$entry_url,$arrow,$url,$author,$date);	# by GLM
		push(@linklist,$listline);	# by GLM
		$num++;
		last if ($num == $var{'conf'}->value('conf_com_disp'));
	}
	push(@linklist,'</ul>');
	$cms->num(0);
	$cms->tag('recent_comment_list'=>join("\n",@linklist));
	return (@linklist > 2) ? 1 : 0;
}
sub _list_trackback { # ȥåХåꥹ from sb::Content
	my $cms = shift;
	my %var = @_;
	my $num = 0;
	my @linklist = ('<ul>');
	# by GLM
	my $set_data = sb::Plugin->get_data;
	my $tb_link = ($set_data->setting ne '') ? $set_data->setting : &sb::Admin::ComTbCustomList::TB_LINK;
	my @strings = split('<>',$set_data->text);
	my $tb_prefix = ($strings[1] ne '') ? $strings[1] : &sb::Admin::ComTbCustomList::TB_PREFIX;
	$tb_prefix = sb::Text->detitize($tb_prefix);
	my $tb_style = ($strings[3] ne '') ? $strings[3] : &sb::Admin::ComTbCustomList::TB_STYLE;
	$tb_style = sb::Text->detitize($tb_style);
	my $arrow = $var{'lang'}->string('parts_arrow');

	my @array = sb::Data->load('Trackback',
		'sort' => 'date',
		'cond' => {'stat'=>1},
		'order'=> 1,
	);
	foreach my $list ( @array ) {
		my $entry = sb::Data->load('Entry','id'=>$list->eid);
		next if (!$entry or $entry->stat == 0 or $entry->atb == 0);
		my $entry_url = $entry->permalink(
			'cat'=>$var{'cat'},
			'mode'=>'',
			'type'=>$var{'conf'}->value('conf_entry_archive')
		);
		my $url = '';	# by GLM
		if($tb_link eq '0') {	# by GLM
			my $id = $list->id;
			$url = $entry_url . '#' . $tb_prefix . $id;
		} else {
			$url = $list->url;
		}
		my $subj = $entry->subj;
		my $date = sb::Time->format(
			'time'=>$list->date,
			'form'=>$var{'conf'}->value('conf_dateinlist'),
			'zone'=>$var{'conf'}->value('conf_timezone')
		);
		my $name = $list->name;
		my $listline = &sb::Plugin::ComTbCustomList::_format_list('<li>%s</li>',$tb_style,$subj,$entry_url,$arrow,$url,$name,$date);	# by GLM
		push(@linklist,$listline);	# by GLM
		$num++;
		last if ($num == $var{'conf'}->value('conf_tb_disp'));
	}
	push(@linklist,'</ul>');
	$cms->num(0);
	$cms->tag('recent_trackback_list'=>join("\n",@linklist));
	return (@linklist > 2) ? 1 : 0;
}
# ==================================================
# // private functions - other utilities
# ==================================================
sub _format_list {
	my $line = shift;
	my $format = shift;
	my $title = shift;
	my $entry_url = shift;
	my $arrow = shift;
	my $url = shift;
	my $name = shift;
	my $date = shift;
	my $out = '';
	$format =~ s/\%Title\%/$title/g;
	$format =~ s/\%EntryUrl\%/$entry_url/g;
	$format =~ s/\%Arrow\%/$arrow/g;
	$format =~ s/\%Url\%/$url/;
	$format =~ s/\%Name\%/$name/;
	$format =~ s/\%Date\%/$date/;
	$out = sprintf($line,$format);
	return($out);
}
package sb::Content::ComTbCustomList;
use sb::Config ();
# ==================================================
# // functions for content
# ==================================================
use sb::Plugin ();
use sb::Text ();
sub _add_id_to_comment {	# from CmsJump.pm _comment_with_id
	my $cms  = shift;
	my $com  = shift;
	# by GLM
	my $set_data = sb::Plugin->get_data;
	my @strings = split('<>',$set_data->text);
	my $com_prefix = ($strings[0] ne '') ? $strings[0] : &sb::Admin::ComTbCustomList::COM_PREFIX;
	$com_prefix = sb::Text->detitize($com_prefix);
	# add comment id
	$cms->tag('comment_id'=>$com_prefix . $com->id);
}
sub _add_id_to_trackback {	# from CmsJump.pm _trackback_with_id
	my $cms  = shift;
	my $tb  = shift;
	# by GLM
	my $set_data = sb::Plugin->get_data;
	my @strings = split('<>',$set_data->text);
	my $tb_prefix = ($strings[1] ne '') ? $strings[1] : &sb::Admin::ComTbCustomList::TB_PREFIX;
	$tb_prefix = sb::Text->detitize($tb_prefix);
	# add trackback id
	$cms->tag('trackback_id'=>$tb_prefix . $tb->id);
}

package sb::Admin::ComTbCustomList;
use vars qw( @ISA );
use sb::Interface ();
use sb::TemplateManager ();
use sb::Language ();
use sb::Text ();
@ISA = qw( sb::App::Admin );
# ==================================================
# // declaration for constant value
# ==================================================
sub TEMPLATE   (){ 'comtbcustomlist.html' };
sub DEFAULT_SCREEN (){ 'setting' };
sub TB_LINK    (){ '0' };
sub COM_PREFIX (){ 'com' };
sub TB_PREFIX  (){ 'tb' };
sub COM_STYLE  (){ '%Title%&lt;br /&gt;%Arrow% &lt;a href=&quot;%Url%&quot;&gt;%Name%%Date%&lt;/a&gt;' };
sub TB_STYLE   (){ '%Title%&lt;br /&gt;%Arrow% &lt;a href=&quot;%Url%&quot;&gt;%Name%%Date%&lt;/a&gt;' };
# ==================================================
# // public functions - callback
# ==================================================
sub callback {
	my $self = shift;
	return ( $self->{'regi'} ) 
		? $self->_save_setting(@_)
		: $self->_show_setting(@_);
}
# ==================================================
# // private functions - main routine
# ==================================================
sub _save_setting {
	my $self = shift;
	my $cgi  = sb::Interface->get;
	my $lang = sb::Language->get;
	# ǡμ
	my $data = sb::Plugin->get_data;
	my $msg = '';
	if($cgi->value('initialize') ne '') {
		$data->setting(TB_LINK);
		$data->text(COM_PREFIX . '<>' . TB_PREFIX . '<>' . COM_STYLE . '<>' . TB_STYLE);
		$msg = $lang->string('parts_ctcl_initialized');
	} else {
	# μ
		$data->setting($cgi->value('tb_link'));
		my $tb_prefix = ($cgi->value('tb_prefix') ne '') ? $cgi->value('tb_prefix') : $cgi->value('tb_prefix_hidden');
		$tb_prefix = sb::Text->entitize($tb_prefix);
		$data->text(sb::Text->entitize($cgi->value('com_prefix')) . '<>' . $tb_prefix . '<>' . sb::Text->entitize($cgi->value('com_style')) . '<>' . sb::Text->entitize($cgi->value('tb_style')));
		$msg = $lang->string('parts_confcomp');
		$msg .= $lang->string('parts_rec_make');
		$msg .= sprintf($lang->string('parts_link_bld'),&sb::App::Admin::get_script_path);
	}
	# ǡ¸
	sb::Plugin->set_data('data' => $data);
	# ¸λåɽ
	return $self->_show_setting('screen' => 'setting','message'=>$msg);
}
sub _show_setting {
	my $self = shift;
	my %param = ('screen' => '','message' => '', @_);
	my $cms  = sb::TemplateManager->new(sb::Plugin->load_template('file' => TEMPLATE));
	my $screen = ($param{'screen'} ne '') ? $param{'screen'} : DEFAULT_SCREEN;
	my $cgi  = sb::Interface->get;
	$screen = $cgi->value('__type') if($cgi->value('__type') ne '');
	if($screen eq 'setting') {	# ξ
		my $set_data = sb::Plugin->get_data;
		my $tb_link = ($set_data->setting ne '') ? $set_data->setting : TB_LINK;
		my @strings = split('<>',$set_data->text);
		my $com_prefix = ($strings[0] ne '') ? $strings[0] : COM_PREFIX;
		my $tb_prefix = ($strings[1] ne '') ? $strings[1] : TB_PREFIX;
		my $com_style = ($strings[2] ne '') ? $strings[2] : COM_STYLE;
		my $tb_style = ($strings[3] ne '') ? $strings[3] : TB_STYLE;
		my $arrow = sb::Language->get->string('parts_arrow');
		# ȼͤ
		$cms->num(0);
		$cms->tag('sb_ctcl_tb_link_0' => ($tb_link eq '0') ? ' selected' : '' );
		$cms->tag('sb_ctcl_tb_link_1' => ($tb_link eq '1') ? ' selected' : '' );
		$cms->tag('sb_ctcl_com_prefix' => $com_prefix );
		$cms->tag('sb_ctcl_tb_prefix' => $tb_prefix );
		$cms->tag('sb_ctcl_tb_prefix_hidden' => $tb_prefix );
		$cms->tag('sb_ctcl_com_style' => $com_style );
		$cms->tag('sb_ctcl_tb_style' => $tb_style );
		$cms->tag('sb_ctcl_arrow' => $arrow );
	}
	# åɽ
	if ($param{'message'} ne '') {
		$cms->tag('sb_process_message' => $param{'message'});
		$cms->block('sb_process_message' => 1);
	}
	$cms->tag('sb_ctcl_menu_' . $screen => 'class="current"');
	$cms->block('sb_ctcl_' . $screen => 1);

	# ̤ɽ
	return sb::Interface->get->head('type'=>'text/html') . $self->set_main($cms->output);
}
1;
# require 뤿Τޤʤ
__END__

Original functions overridden

*sb::Content
Version:0.13

sub _list_comment { # ȥꥹ
	my $cms = shift;
	my %var = @_;
	my $num = 0;
	my @linklist = ('<ul>');
	my @array = sb::Data->load('Message',
		'sort' => 'date',
		'cond' => {'stat'=>1},
		'order'=> 1,
	);
	foreach my $list ( @array ) {
		my $entry = sb::Data->load('Entry','id'=>$list->eid);
		next if (!$entry or $entry->stat == 0 or $entry->acm == 0);
		my $url  = $entry->permalink(
			'cat'=>$var{'cat'},
			'mode'=>'com',
			'type'=>$var{'conf'}->value('conf_entry_archive')
		);
		my $subj = $entry->subj;
		my $date = sb::Time->format(
			'time'=>$list->date,
			'form'=>$var{'conf'}->value('conf_dateinlist'),
			'zone'=>$var{'conf'}->value('conf_timezone')
		);
		my $arrow = $var{'lang'}->string('parts_arrow');
		my $author = $list->auth;
		push(@linklist,qq|<li>$subj<br />$arrow <a href="$url">$author$date</a></li>|);
		$num++;
		last if ($num == $var{'conf'}->value('conf_com_disp'));
	}
	push(@linklist,'</ul>');
	$cms->num(0);
	$cms->tag('recent_comment_list'=>join("\n",@linklist));
	return (@linklist > 2) ? 1 : 0;
}
sub _list_trackback { # ȥåХåꥹ
	my $cms = shift;
	my %var = @_;
	my $num = 0;
	my @linklist = ('<ul>');
	my @array = sb::Data->load('Trackback',
		'sort' => 'date',
		'cond' => {'stat'=>1},
		'order'=> 1,
	);
	foreach my $list ( @array ) {
		my $entry = sb::Data->load('Entry','id'=>$list->eid);
		next if (!$entry or $entry->stat == 0 or $entry->atb == 0);
		my $url = $entry->permalink(
			'cat'=>$var{'cat'},
			'mode'=>'tb',
			'type'=>$var{'conf'}->value('conf_entry_archive')
		);
		my $subj = $entry->subj;
		my $date = sb::Time->format(
			'time'=>$list->date,
			'form'=>$var{'conf'}->value('conf_dateinlist'),
			'zone'=>$var{'conf'}->value('conf_timezone')
		);
		my $arrow = $var{'lang'}->string('parts_arrow');
		my $name = $list->name;
		push(@linklist,qq|<li>$subj<br />$arrow <a href="$url">$name$date</a></li>|);
		$num++;
		last if ($num == $var{'conf'}->value('conf_tb_disp'));
	}
	push(@linklist,'</ul>');
	$cms->num(0);
	$cms->tag('recent_trackback_list'=>join("\n",@linklist));
	return (@linklist > 2) ? 1 : 0;
}
